package com.bxm.adx.common.market.exchange.rebuild.request;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.sell.BidRequest;
import org.springframework.context.annotation.Configuration;

import java.util.Objects;

/**
 * @author fgf
 * @date 2023/1/9
 **/
@Configuration
public class RequestBuilder implements AdxBidRequestBuilder {
    @Override
    public void rebuildAdxBidRequest(BidRequest adxBidRequest, RequestBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getBuyerWrapper().getDispatcher();
        DispatcherPriceConfig config = dispatcher.getDispatcherPriceConfig();
        adxBidRequest.setDspPriceCoefficient(Objects.isNull(config) ? null : config.getBiddingCoefficient().doubleValue());
    }
}
