package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.market.Deal;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author fgf
 * @date 2023/4/4
 **/
@Slf4j
@Configuration
@DealFilterCondition(preview = true)
public class ExceptionDealFilter implements Filter {
    @Override
    public void filter(List<Deal> deals, Set<Deal> trash) {
        Set<Deal> remove = deals.stream().filter(
                deal -> {
                    return Objects.nonNull(deal.getAdxErrEnum());
                }
        ).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(remove)) {
            trash.addAll(remove);
        }
    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE;
    }
}
