package com.bxm.adx.common.market.filter;

/**
 * @author fgf
 * @date 2023/3/27
 **/
public enum FilterEnum {
    //未知
    Undefined(0),
    //bes domain过滤
    BesDomainFilter(1),
    //无效参竞
    NoBidFilter(2),
    //广告优化过滤
    OptimizationFilter(3),
    //底价过滤
    PriceBidFloorFilter(4),
    //最高价过滤
    PriceLowerFilter(5),
    //优先级过滤
    PriorityFilter(6),
    //超时
    Overtime(7),
    //adx err
    ExceptionDealFilter(8),
    ;
    private int type;

    FilterEnum(int type) {
        this.type = type;
    }

    public int getType() {
        return type;
    }
}
