package com.bxm.adx.common.market.nbr;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.DeviceCrowdPackageJedisProperties;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.limiter.InsertExpireHandler;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.warcar.cache.KeyGenerator;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

import java.util.Map;
import java.util.Objects;

/**
 * @author fgf
 * @date 2023/4/4
 **/
@Slf4j
public class BlockDeviceHandler implements NoBidResponseHandler {
    private final InsertExpireHandler insertExpireHandler;
    private final DeviceCrowdPackageJedisProperties properties;
    private final int EXPIRE = 24 * 3600;

    public BlockDeviceHandler(InsertExpireHandler insertExpireHandler, DeviceCrowdPackageJedisProperties properties) {
        this.insertExpireHandler = insertExpireHandler;
        this.properties = properties;
    }


    @Override
    public void handler(Deal... deals) {
        if (ArrayUtils.isEmpty(deals)) {
            return;
        }
        KeyGenerator key = keyGenerator(deals);
        if (Objects.isNull(key)) {
            return;
        }
        Map<String, String> blockConfigs = properties.getBlockCrowdPackConfigs();
        for (Deal deal : deals) {
            String crowdPackId = getCrowdPackId(deal, blockConfigs);
            if (StringUtils.isBlank(crowdPackId)) {
                continue;
            }
            Long expireVal = deal.getBidResponse().getCdt();
            if (Objects.isNull(expireVal)) {
                continue;
            }
            insertExpireHandler.insert(key, crowdPackId, String.valueOf(expireVal), EXPIRE);
        }
    }

    @Override
    public int nbr() {
        return AdxConstants.Nbr.BLOCK_DEVICE;
    }

    /**
     * 获取dsp对应的人群包id
     *
     * @param deal
     * @param blockConfigs
     * @return
     */
    private String getCrowdPackId(Deal deal, Map<String, String> blockConfigs) {
        Buyer buyer = deal.getBuyer();
        if (Objects.nonNull(buyer)) {
            Dsp dsp = buyer.getDsp();
            String dspCode = dsp.getDspCode();
            return blockConfigs.get(dspCode);
        }
        return null;
    }

    /**
     * 获取redis-key
     *
     * @param deals
     * @return
     */
    private KeyGenerator keyGenerator(Deal... deals) {
        for (Deal deal : deals) {
            BidRequest request = deal.getBidRequest();
            if (Objects.nonNull(request)) {
                return CacheKeys.getCrowdPackageNewKey(request.getDevice());
            }
        }
        return null;
    }
}
