package com.bxm.adx.common.market.nbr;

import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.exchange.ExchangeResult;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.utils.MapHelper;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * nbr-handler策略处理选择
 *
 * @author fgf
 * @date 2023/4/5
 **/
@Service
@Slf4j
public class NoBidResponseService implements ApplicationListener<ApplicationReadyEvent> {
    private Map<Integer, ? extends NoBidResponseHandler> handlers;

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext context = event.getApplicationContext();
        Map<String, NoBidResponseHandler> handlerMap = context.getBeansOfType(NoBidResponseHandler.class);
        if (CollectionUtils.isEmpty(handlerMap)) {
            log.info("noBidResponse-handler empty");
            return;
        }
        handlers = handlerMap.values().stream().collect(Collectors.toMap(NoBidResponseHandler::nbr, noBidResponseHandler -> noBidResponseHandler));
    }

    public void handler(ExchangeResult exchangeResult) {
        if (CollectionUtils.isEmpty(handlers)) {
            return;
        }
        Map<Integer, Set<Deal>> trash = exchangeResult.getTrash();
        if (CollectionUtils.isEmpty(trash)) {
            return;
        }
        Map<Integer, Set<Deal>> nbrDeals = Maps.newHashMap();
        for (Set<Deal> deals : trash.values()) {
            for (Deal deal : deals) {
                BidResponse response = deal.getBidResponse();
                if (Objects.isNull(response)) {
                    continue;
                }
                Integer nbr = response.getNbr();
                if (Objects.isNull(nbr)) {
                    continue;
                }
                MapHelper.get(nbrDeals, nbr, new HashSet<>()).add(deal);
            }
        }
        nbrDeals.forEach(
                (k, v) -> {
                    NoBidResponseHandler handler = handlers.get(k);
                    if (Objects.nonNull(handler)) {
                        handler.handler(v.toArray(new Deal[0]));
                    }
                }
        );
    }
}
