package com.bxm.adx.common.micrometer.aspect;

import com.bxm.adx.common.market.filter.Filter;
import com.google.common.collect.Maps;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.ClassUtils;

import java.util.Map;

/**
 * @author fgf
 * @date 2023/3/7
 **/
@Slf4j
public class DealFilterMicroMeter implements MeterBinder {

    private final Map<Class, Timer> timers = Maps.newConcurrentMap();
    private final Iterable<Filter> filters;

    public DealFilterMicroMeter(Iterable<Filter> filters) {
        this.filters = filters;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        for (Filter filter : filters) {
            Class<?> clazz = ClassUtils.getUserClass(filter);
            Timer timer = Timer.builder("deal.filter").tag("name", clazz.getName()).register(registry);
            timers.put(clazz, timer);
            log.info("Registering Deal filter {} timer meter successful.", filter);
        }
    }

    Timer get(Filter filter) {
        return timers.get(ClassUtils.getUserClass(filter));
    }
}
