package com.bxm.adx.common.sell.init;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.PositionSceneTypeEnum;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.request.Impression;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author fgf
 * @date 2022/8/26
 **/
@Configuration
public class ImpressionInitializer implements BidRequestInitializer {
    @Override
    public void accept(BidRequest request, InitializerParam param) {
        if (CollectionUtils.isNotEmpty(request.getImps())) {
            Position position = param.getPosition();
            if (Objects.isNull(position)) {
                return;
            }
            for (Impression impression : request.getImps()) {
                //初始化底价
                if (Objects.isNull(impression.getBid_floor())) {
                    impression.setBid_floor(BigDecimal.ZERO);
                }
                //广告位替换
                request.setMediaTagId(impression.getTag_id());
                impression.setTag_id(position.getPositionId());
                //初始化imp.id
                if (StringUtils.isEmpty(impression.getId())) {
                    impression.setId(request.getId());
                }
                //初始化imp.imp_type
                if (Objects.isNull(impression.getImp_type())) {
                    impression.setImp_type(position.getPositionScene().intValue());
                }
                //初始化imp.type
                initImpressionType(impression, position);
                // //初始化imp.w&h
                insertOrUpdateImpressionSize(impression, param.getPosition());
            }
        }
    }

    /**
     * 填充impType
     *
     * @param impression
     * @param position
     */
    private void initImpressionType(Impression impression, Position position) {
        if (Objects.isNull(impression.getType())) {
            Integer positionScene = position.getPositionScene().intValue();
            PositionSceneTypeEnum typeEnum = PositionSceneTypeEnum.get(positionScene);
            if (Objects.nonNull(typeEnum)) {
                switch (typeEnum) {
                    case BOOT:
                    case SCREEN:
                        impression.setType(AdxConstants.Type.IMAGE.getType());
                        break;
                    case VIDEO:
                    case INSPIRE_VIDEO:
                        impression.setType(AdxConstants.Type.VIDEO.getType());
                        break;
                    case INFORMATION_FLOW:
                        impression.setType(AdxConstants.Type.NATIVE.getType());
                }
            }
        }
    }

    /**
     * 填充imp尺寸
     *
     * @param imp
     * @param position
     */
    private void insertOrUpdateImpressionSize(Impression imp, Position position) {
        if (Objects.nonNull(imp.getW()) && Objects.nonNull(imp.getH())) {
            return;
        }
        String positionSize = position.getPositionSize();
        if (org.apache.commons.lang.StringUtils.isBlank(positionSize)) {
            return;
        }
        String[] sizeArray = positionSize.split(" ")[0].split("\\*");
        if (sizeArray.length != 2) {
            return;
        }
        if (org.apache.commons.lang.StringUtils.isNumeric(sizeArray[0])) {
            imp.setW(Integer.parseInt(sizeArray[0]));
        }
        if (org.apache.commons.lang.StringUtils.isNumeric(sizeArray[1])) {
            imp.setH(Integer.parseInt(sizeArray[1]));
        }
    }

    @Override
    public int getOrder() {
        return 0;
    }
}
