package com.bxm.adx.common.sell.position.dsp;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 广告位场景-活动
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-08-13
 */
@Data
public class SceneActivity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 广告位ID
     */
    private String positionId;

    /**
     * 活动id
     */
    private String activityId;

    /**
     * 活动url
     */
    private String activityUrl;

    /**
     * 活动应用类型：1直接投放，2测试活动
     */
    private Integer type;

    /**
     * 有效期开始
     */
    private Date startDate;

    /**
     * 有效期结束
     */
    private Date endDate;

    /**
     * 流量分配占比
     */
    private Integer rateOfFlow;

    /**
     * 广告位配置json格式
     * [
     *     {
     *         "id": 1,
     *         "positionScene": 1,
     *         "informationFlowTemplate": 2,
     *         "positionId": 804434342111
     *     },
     *     {
     *         "id": 2,
     *         "positionScene": 3,
     *         "informationFlowTemplate": null,
     *         "positionId": 804434342754
     *     }
     * ]
     */
    private String positionConfig;

    /**
     * 开关,1:开,0:关
     */
    private Integer opened;

}
