/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common;

import com.bxm.adx.common.utils.DateUtils;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;

public class DotEventControlProperties {
    private String id;
    private String sspPositionId;
    private String dspId;
    private String dspPositionId;
    private int mt = 5;
    private String startDateTime;
    private String endDateTime;
    private TimeUnit timeUnit = TimeUnit.MINUTES;
    private Integer timeInterval = 10;
    private long total;
    private byte model = 1;
    private LocalDateTime start;
    private LocalDateTime end;

    public void setStartDateTime(String startDateTime) {
        this.startDateTime = startDateTime;
        this.start = DateUtils.convertLocalDateTime(startDateTime);
    }

    public void setEndDateTime(String endDateTime) {
        this.endDateTime = endDateTime;
        this.end = DateUtils.convertLocalDateTime(endDateTime);
    }

    public long getIntervalLimit(int exposedCount) {
        long limit = 0L;
        if (this.end.isAfter(this.start)) {
            LocalDateTime now = LocalDateTime.now();
            Duration duration = null;
            duration = now.isBefore(this.start) ? Duration.between(this.start, this.end) : Duration.between(now, this.end);
            long minutes = duration.toMinutes();
            long section = (int)Math.ceil((double)minutes / (double)this.timeInterval.intValue());
            limit = (this.total - (long)exposedCount) / section;
        }
        return limit;
    }

    public String getSectionId(LocalDateTime now) {
        Duration duration = Duration.between(this.start, now);
        long minutes = duration.toMinutes();
        long section = (int)Math.ceil((double)minutes / (double)this.timeInterval.intValue());
        return String.valueOf(section);
    }

    public String getId() {
        return this.id;
    }

    public String getSspPositionId() {
        return this.sspPositionId;
    }

    public String getDspId() {
        return this.dspId;
    }

    public String getDspPositionId() {
        return this.dspPositionId;
    }

    public int getMt() {
        return this.mt;
    }

    public String getStartDateTime() {
        return this.startDateTime;
    }

    public String getEndDateTime() {
        return this.endDateTime;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Integer getTimeInterval() {
        return this.timeInterval;
    }

    public long getTotal() {
        return this.total;
    }

    public byte getModel() {
        return this.model;
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    public LocalDateTime getEnd() {
        return this.end;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSspPositionId(String sspPositionId) {
        this.sspPositionId = sspPositionId;
    }

    public void setDspId(String dspId) {
        this.dspId = dspId;
    }

    public void setDspPositionId(String dspPositionId) {
        this.dspPositionId = dspPositionId;
    }

    public void setMt(int mt) {
        this.mt = mt;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void setTimeInterval(Integer timeInterval) {
        this.timeInterval = timeInterval;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setModel(byte model) {
        this.model = model;
    }

    public void setStart(LocalDateTime start) {
        this.start = start;
    }

    public void setEnd(LocalDateTime end) {
        this.end = end;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DotEventControlProperties)) {
            return false;
        }
        DotEventControlProperties other = (DotEventControlProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMt() != other.getMt()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getModel() != other.getModel()) {
            return false;
        }
        Integer this$timeInterval = this.getTimeInterval();
        Integer other$timeInterval = other.getTimeInterval();
        if (this$timeInterval == null ? other$timeInterval != null : !((Object)this$timeInterval).equals(other$timeInterval)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$sspPositionId = this.getSspPositionId();
        String other$sspPositionId = other.getSspPositionId();
        if (this$sspPositionId == null ? other$sspPositionId != null : !this$sspPositionId.equals(other$sspPositionId)) {
            return false;
        }
        String this$dspId = this.getDspId();
        String other$dspId = other.getDspId();
        if (this$dspId == null ? other$dspId != null : !this$dspId.equals(other$dspId)) {
            return false;
        }
        String this$dspPositionId = this.getDspPositionId();
        String other$dspPositionId = other.getDspPositionId();
        if (this$dspPositionId == null ? other$dspPositionId != null : !this$dspPositionId.equals(other$dspPositionId)) {
            return false;
        }
        String this$startDateTime = this.getStartDateTime();
        String other$startDateTime = other.getStartDateTime();
        if (this$startDateTime == null ? other$startDateTime != null : !this$startDateTime.equals(other$startDateTime)) {
            return false;
        }
        String this$endDateTime = this.getEndDateTime();
        String other$endDateTime = other.getEndDateTime();
        if (this$endDateTime == null ? other$endDateTime != null : !this$endDateTime.equals(other$endDateTime)) {
            return false;
        }
        TimeUnit this$timeUnit = this.getTimeUnit();
        TimeUnit other$timeUnit = other.getTimeUnit();
        if (this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit)) {
            return false;
        }
        LocalDateTime this$start = this.getStart();
        LocalDateTime other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        LocalDateTime this$end = this.getEnd();
        LocalDateTime other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DotEventControlProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMt();
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        result = result * 59 + this.getModel();
        Integer $timeInterval = this.getTimeInterval();
        result = result * 59 + ($timeInterval == null ? 43 : ((Object)$timeInterval).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $sspPositionId = this.getSspPositionId();
        result = result * 59 + ($sspPositionId == null ? 43 : $sspPositionId.hashCode());
        String $dspId = this.getDspId();
        result = result * 59 + ($dspId == null ? 43 : $dspId.hashCode());
        String $dspPositionId = this.getDspPositionId();
        result = result * 59 + ($dspPositionId == null ? 43 : $dspPositionId.hashCode());
        String $startDateTime = this.getStartDateTime();
        result = result * 59 + ($startDateTime == null ? 43 : $startDateTime.hashCode());
        String $endDateTime = this.getEndDateTime();
        result = result * 59 + ($endDateTime == null ? 43 : $endDateTime.hashCode());
        TimeUnit $timeUnit = this.getTimeUnit();
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
        LocalDateTime $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        LocalDateTime $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }

    public String toString() {
        return "DotEventControlProperties(id=" + this.getId() + ", sspPositionId=" + this.getSspPositionId() + ", dspId=" + this.getDspId() + ", dspPositionId=" + this.getDspPositionId() + ", mt=" + this.getMt() + ", startDateTime=" + this.getStartDateTime() + ", endDateTime=" + this.getEndDateTime() + ", timeUnit=" + (Object)((Object)this.getTimeUnit()) + ", timeInterval=" + this.getTimeInterval() + ", total=" + this.getTotal() + ", model=" + this.getModel() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ")";
    }
}

