/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ExceptionAdvice {
    private static final Logger log = LoggerFactory.getLogger(ExceptionAdvice.class);
    private final ObjectMapper objectMapper;

    public ExceptionAdvice(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Object> handleException(Exception ex) {
        if (log.isErrorEnabled()) {
            log.error("catch error = ", (Throwable)ex);
        }
        return ResponseEntity.ok().build();
    }
}

