/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.adapter.aspect;

import com.bxm.adx.common.adapter.AbstractPluginBidModelAdapter;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.warcar.dpl2.plugin.PluginConfig;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
public class BidModelPluginEnhanceAspect {
    @Pointcut(value="this(com.bxm.adx.common.adapter.BidModelAdapter) && execution(com.bxm.adx.common.sell.BidRequest convert(..))")
    public void pointcut() {
    }

    @AfterReturning(pointcut="pointcut()", returning="returnVal")
    public void afterReturning(JoinPoint point, Object returnVal) throws Throwable {
        if (null == returnVal) {
            return;
        }
        BidRequest request = (BidRequest)returnVal;
        Object target = point.getTarget();
        if (target instanceof AbstractPluginBidModelAdapter) {
            Properties properties = this.getProperties(target);
            if (StringUtils.isBlank((String)request.getMediaId())) {
                request.setMediaId(this.getMediaId(properties));
            }
            if (null == request.getEncModel()) {
                request.setEncModel(this.getEncModel(properties));
            }
        }
    }

    private Properties getProperties(Object target) {
        AbstractPluginBidModelAdapter adapter = (AbstractPluginBidModelAdapter)target;
        PluginConfig pluginConfig = adapter.getPluginConfig();
        return pluginConfig.getProperties();
    }

    private String getMediaId(Properties properties) {
        String mediaId = properties.getProperty("id");
        return mediaId;
    }

    private Integer getEncModel(Properties properties) {
        String encm = properties.getProperty("encm");
        try {
            Integer model = Integer.valueOf(encm);
            return model;
        }
        catch (Exception e) {
            return 0;
        }
    }
}

