/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.autoconfigure;

import com.bxm.adx.common.adapter.BidModelAdapter;
import com.bxm.adx.common.adapter.aspect.ModelAdapterRequestLogAdvice;
import com.bxm.adx.common.log.AdxDataLogMonitor;
import com.bxm.adx.common.log.ByteLogger;
import com.bxm.adx.common.log.buriedSwitch.BuriedSwitchCached;
import com.bxm.adx.common.sell.position.mapping.PositionMappingStrategyFactory;
import com.bxm.warcar.dpl2.plugin.spring.BeforeRefreshContextHandler;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.NameMatchMethodPointcut;
import org.springframework.aop.support.RootClassFilter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(prefix="adx", name={"enable-model-adapter-proxy-factory"}, matchIfMissing=false, havingValue="true")
public class ModelAdapterProxyFactoryAutoConfiguration
implements BeforeRefreshContextHandler {
    private static final Logger log = LoggerFactory.getLogger(ModelAdapterProxyFactoryAutoConfiguration.class);
    private final ByteLogger byteLogger;
    private final PositionMappingStrategyFactory positionMappingStrategyFactory;
    private final BuriedSwitchCached buriedSwitchCached;
    private final AdxDataLogMonitor adxDataLogMonitor;

    public ModelAdapterProxyFactoryAutoConfiguration(ApplicationContext applicationContext) {
        this.byteLogger = (ByteLogger)applicationContext.getBean(ByteLogger.class);
        this.positionMappingStrategyFactory = (PositionMappingStrategyFactory)applicationContext.getBean(PositionMappingStrategyFactory.class);
        this.buriedSwitchCached = (BuriedSwitchCached)applicationContext.getBean(BuriedSwitchCached.class);
        this.adxDataLogMonitor = (AdxDataLogMonitor)applicationContext.getBean(AdxDataLogMonitor.class);
    }

    @Bean
    public ModelAdapterRequestLogAdvice modelAdapterAdvice() {
        return new ModelAdapterRequestLogAdvice(this.byteLogger, this.positionMappingStrategyFactory, this.buriedSwitchCached, this.adxDataLogMonitor);
    }

    @Bean
    public NameMatchMethodPointcut modelAdapterPointcut() {
        NameMatchMethodPointcut pointcut = new NameMatchMethodPointcut();
        pointcut.setClassFilter((ClassFilter)new RootClassFilter(BidModelAdapter.class));
        pointcut.setMappedName("convert");
        return pointcut;
    }

    @Bean
    public DefaultPointcutAdvisor modelAdapterAdvisor() {
        return new DefaultPointcutAdvisor((Pointcut)this.modelAdapterPointcut(), (Advice)this.modelAdapterAdvice());
    }

    public void accept(AnnotationConfigApplicationContext annotationConfigApplicationContext) {
        ConfigurableListableBeanFactory beanFactory = annotationConfigApplicationContext.getBeanFactory();
        beanFactory.addBeanPostProcessor(new BeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof BidModelAdapter) {
                    ProxyFactory factory = new ProxyFactory();
                    factory.setTarget(bean);
                    factory.addAdvisor((Advisor)ModelAdapterProxyFactoryAutoConfiguration.this.modelAdapterAdvisor());
                    return factory.getProxy();
                }
                return bean;
            }
        });
    }
}

