/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher.control;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.control.AlgoFlowControl;
import com.bxm.adx.common.buy.dispatcher.control.AlgoFlowControlChangeHandler;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AlgoFlowControlCached
implements AlgoFlowControlChangeHandler {
    private final ConcurrentHashMap<String, Set<String>> algoFlowControlMap = new ConcurrentHashMap();

    @Override
    public void doUpdate(AlgoFlowControl old, AlgoFlowControl latest) {
        if (this.isExecuteUpdateAndDoDelete(old, latest)) {
            this.algoFlowControlMap.put(latest.getUniqueKey(), Sets.newHashSet((Object[])latest.getValue().split(",")));
        }
    }

    @Override
    public void doDelete(AlgoFlowControl old) {
        this.algoFlowControlMap.remove(old.getUniqueKey());
    }

    public Set<String> getAlgoControlBundles(Dispatcher dispatcher) {
        String key = this.getKeyByDispatcher(dispatcher);
        return this.algoFlowControlMap.get(key);
    }

    private String getKeyByDispatcher(Dispatcher dispatcher) {
        String positionId = dispatcher.getPositionId();
        Long dspId = dispatcher.getDspId();
        String dspPosId = dispatcher.getDspPosid();
        return positionId + "-" + dspId + "-" + dspPosId;
    }
}

