/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher.filter;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilter;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilterCondition;
import com.bxm.adx.common.caching.Id;
import com.bxm.adx.common.rule.AndOrSetRule;
import com.bxm.adx.common.rule.Rule;
import com.bxm.adx.common.sell.request.Device;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@DispatcherFilterCondition(probeOn=false)
@Configuration
public class DeviceFilter
implements DispatcherFilter<Dispatcher> {
    private static final Logger log = LoggerFactory.getLogger(DeviceFilter.class);
    private static final Set<String> DEVICE_ID_NAMES = Sets.newHashSet((Object[])new String[]{"imei", "idfa", "oaid", "gaid"});

    @Override
    public void filter(DispatcherContext<Dispatcher> context, Set<Id> trash) {
        Device device = context.getRequest().getDevice();
        Set removes = context.getValues().stream().filter(dispatcher -> this.limitByDevice((Dispatcher)dispatcher, device)).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(removes)) {
            trash.addAll(removes);
        }
    }

    public int getOrder() {
        return 1;
    }

    private boolean limitByDevice(Dispatcher dispatcher, Device device) {
        Rule deviceRule = dispatcher.getDeviceInfo();
        if (Objects.isNull(deviceRule)) {
            return false;
        }
        AndOrSetRule andOrSetRule = new AndOrSetRule(deviceRule);
        Set<String> paramNames = andOrSetRule.getAndParamNameSet();
        for (String paramName : paramNames) {
            if (andOrSetRule.isOrParams(paramName)) {
                Set<String> orParams = andOrSetRule.getOrParamNameSet(paramName);
                if (CollectionUtils.isEmpty(orParams)) continue;
                boolean orLimit = false;
                for (String orParamName : orParams) {
                    if (!this.hasFieldVal(device, orParamName)) continue;
                    orLimit = true;
                    break;
                }
                if (orLimit) continue;
                return true;
            }
            if (this.hasFieldVal(device, paramName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasFieldVal(Device device, String fieldName) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add(fieldName);
        if (DEVICE_ID_NAMES.contains(fieldName)) {
            fieldNames.add(fieldName + "_md5");
        }
        try {
            Class<?> cla = device.getClass();
            for (String name : fieldNames) {
                boolean hasVal;
                Field field = cla.getDeclaredField(name);
                field.setAccessible(true);
                Object val = field.get(device);
                if (log.isDebugEnabled()) {
                    log.debug("check device param {} val {}", (Object)name, Optional.ofNullable(val).orElse(null));
                }
                if (!(hasVal = Objects.nonNull(val) && StringUtils.isNotBlank((String)val.toString()))) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

