/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher.reorder;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.buy.dispatcher.reorder.DispatcherOrderStrategy;
import com.bxm.adx.common.buy.dispatcher.reorder.DispatcherReorder;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
public class DispatcherReorderFactory
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(DispatcherReorderFactory.class);
    private final Map<DispatcherOrderStrategy, DispatcherReorder> dispatcherReorders = Maps.newHashMap();

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext context = event.getApplicationContext();
        Map dispatcherReorderMap = context.getBeansOfType(DispatcherReorder.class);
        if (!CollectionUtils.isEmpty((Map)dispatcherReorderMap)) {
            this.dispatcherReorders.putAll(dispatcherReorderMap.values().stream().collect(Collectors.toMap(DispatcherReorder::orderStrategy, dispatcherReorder -> dispatcherReorder)));
        }
    }

    public Collection<Dispatcher> reorder(DispatcherContext<Dispatcher> context) {
        Integer dmType = context.getPosition().getDockingMethodType();
        if (Objects.nonNull(dmType) && 2 == dmType) {
            if (context.getSdkConcurrentModel()) {
                return this.dispatcherReorders.get((Object)DispatcherOrderStrategy.sdk_concurrency).reorder(context);
            }
            return this.dispatcherReorders.get((Object)DispatcherOrderStrategy.sdk_common).reorder(context);
        }
        return context.getValues();
    }
}

