/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.filter;

import com.bxm.adx.common.filter.AbstractPositionFilter;
import com.bxm.adx.common.filter.LimitConfig;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.rule.LimitRule;
import com.bxm.adx.common.rule.Rule;
import com.bxm.adx.common.sell.position.Position;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionLimitFilter
extends AbstractPositionFilter {
    private static final Logger log = LoggerFactory.getLogger(PositionLimitFilter.class);

    @Override
    protected List<String> doFilter(MarketOrders marketOrders) {
        List<Position> positions = marketOrders.getPositions();
        ArrayList removes = Lists.newArrayList();
        positions.forEach(position -> {
            Rule rule = position.getFrequencyControl();
            if (Objects.isNull(rule)) {
                return;
            }
            LimitRule limitRule = new LimitRule(rule);
            Set<LimitConfig> configs = limitRule.getSet();
            if (CollectionUtils.isEmpty(configs)) {
                return;
            }
        });
        return removes;
    }

    @Override
    public int order() {
        return 0;
    }
}

