/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.filter;

import com.bxm.adx.common.filter.AbstractPositionFilter;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.utils.AdxUtils;
import com.bxm.mcssp.common.entity.PositionJsonConfig;
import com.bxm.mcssp.common.enums.position.PositionSceneTypeEnum;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PositionPushIntervalTimesFilter
extends AbstractPositionFilter {
    private static final Logger log = LoggerFactory.getLogger(PositionPushIntervalTimesFilter.class);
    @Autowired
    private Counter counter;

    @Override
    protected List<String> doFilter(MarketOrders marketOrders) {
        if (marketOrders.getBidRequest().isAppDrivingRequest()) {
            return null;
        }
        List<Position> positions = marketOrders.getPositions();
        if (CollectionUtils.isEmpty(positions)) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        positions.forEach(position -> {
            Integer intervalTime = this.getIntervalTime((Position)position);
            if (null == intervalTime || intervalTime <= 0) {
                return;
            }
            KeyGenerator key = () -> KeyBuilder.build((Object[])new Object[]{"statistics", "adx", "show", "user", "lasttime", position.getPositionId(), marketOrders.getUid()});
            Long lastTime = this.counter.get(key);
            if (lastTime == null) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now > lastTime + (long)(intervalTime * 60 * 1000) - 10000L) {
                return;
            }
            list.add(position.getPositionId());
        });
        return list;
    }

    private Integer getIntervalTime(Position position) {
        PositionJsonConfig positionJsonConfig;
        String jsonConfig;
        PositionSceneTypeEnum typeEnum;
        Byte pScene = position.getPositionScene();
        if (Objects.nonNull(pScene) && Objects.nonNull(typeEnum = PositionSceneTypeEnum.get((Integer)pScene.intValue())) && !StringUtils.isEmpty((Object)(jsonConfig = position.getJsonConfig())) && Objects.nonNull(positionJsonConfig = AdxUtils.getJsonConfig(jsonConfig))) {
            switch (typeEnum) {
                case PUSH: {
                    PositionJsonConfig.Push push = positionJsonConfig.getPush();
                    if (push == null) {
                        return null;
                    }
                    if (Objects.nonNull(push.getMinIntervalBetweenTwoExposures())) {
                        return push.getMinIntervalBetweenTwoExposures();
                    }
                    if (Objects.nonNull(position.getPushIntervalTime())) {
                        return position.getPushIntervalTime();
                    }
                    return null;
                }
                case SCREEN: {
                    PositionJsonConfig.Screen screen = positionJsonConfig.getScreen();
                    if (screen == null) {
                        return null;
                    }
                    return screen.getMinIntervalBetweenTwoExposures();
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public int order() {
        return 2;
    }
}

