/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market;

import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import java.util.List;
import java.util.Objects;
import org.springframework.util.CollectionUtils;

public class Deal {
    public static final byte HTTP_DEAL = 0;
    public static final byte CACHE_DEAL = 1;
    private byte type = 0;
    private Buyer buyer;
    private Dispatcher dispatcher;
    private byte[] request;
    private byte[] response;
    private BidRequest bidRequest;
    private BidRequest adxRequest;
    private BidResponse bidResponse;
    private AdxErrEnum adxErrEnum;
    private Boolean bidSuccess;

    public Deal(Dispatcher dispatcher, BidRequest bidRequest) {
        this.dispatcher = dispatcher;
        this.bidRequest = bidRequest;
    }

    public Deal(Buyer buyer, BidRequest bidRequest, BidResponse bidResponse, Dispatcher dispatcher) {
        this.buyer = buyer;
        this.bidRequest = bidRequest;
        this.bidResponse = bidResponse;
        this.dispatcher = dispatcher;
    }

    public Deal(byte type, Buyer buyer, BidRequest bidRequest, BidResponse bidResponse, Dispatcher dispatcher) {
        this.type = type;
        this.buyer = buyer;
        this.bidRequest = bidRequest;
        this.bidResponse = bidResponse;
        this.dispatcher = dispatcher;
        if (type == 1) {
            this.bidSuccess = true;
        }
    }

    public Deal(Buyer buyer, byte[] request, byte[] response, BidRequest bidRequest) {
        this.buyer = buyer;
        this.request = request;
        this.response = response;
        this.bidRequest = bidRequest;
    }

    public Deal(Buyer buyer, byte[] request, byte[] response, BidRequest bidRequest, BidRequest adxRequest, Dispatcher dispatcher) {
        this.buyer = buyer;
        this.request = request;
        this.response = response;
        this.bidRequest = bidRequest;
        this.adxRequest = adxRequest;
        this.dispatcher = dispatcher;
    }

    public Deal(Buyer buyer, byte[] request, BidRequest bidRequest, BidRequest adxRequest, AdxErrEnum adxErrEnum, Dispatcher dispatcher) {
        this.buyer = buyer;
        this.request = request;
        this.bidRequest = bidRequest;
        this.adxRequest = adxRequest;
        this.adxErrEnum = adxErrEnum;
        this.dispatcher = dispatcher;
    }

    public boolean isBidSuccess() {
        if (Objects.isNull(this.bidSuccess)) {
            this.bidSuccess = Objects.nonNull(this.getBidResponse()) && this.hasBid();
        }
        return this.bidSuccess;
    }

    public BidResponse getBidResponse() {
        if (null == this.bidResponse) {
            BuyModelAdapter modelAdapter = this.buyer.getModelAdapter();
            if (null != this.response && this.response.length > 0) {
                this.bidResponse = modelAdapter.buildResponse(this.response);
            }
        }
        return this.bidResponse;
    }

    public boolean hasBid() {
        if (Objects.nonNull(this.bidResponse.getNbr())) {
            return false;
        }
        List<SeatBid> seatBids = this.bidResponse.getSeat_bid();
        if (CollectionUtils.isEmpty(seatBids)) {
            return false;
        }
        for (SeatBid seatBid : seatBids) {
            List<Bid> bids = seatBid.getBid();
            if (CollectionUtils.isEmpty(bids)) continue;
            return true;
        }
        return false;
    }

    public boolean isOp() {
        String code = this.buyer.getCode();
        return "optimization".equalsIgnoreCase(code);
    }

    public Buyer getBuyer() {
        return this.buyer;
    }

    public void setBuyer(Buyer buyer) {
        this.buyer = buyer;
    }

    public byte[] getRequest() {
        return this.request;
    }

    public void setRequest(byte[] request) {
        this.request = request;
    }

    public byte[] getResponse() {
        return this.response;
    }

    public void setResponse(byte[] response) {
        this.response = response;
    }

    public BidRequest getBidRequest() {
        return this.bidRequest;
    }

    public AdxErrEnum getAdxErrEnum() {
        return this.adxErrEnum;
    }

    public BidRequest getAdxRequest() {
        return this.adxRequest;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public byte getType() {
        return this.type;
    }

    public Boolean getBidSuccess() {
        return this.bidSuccess;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Deal deal = (Deal)o;
        return this.getType() == deal.getType() && this.getDispatcher().equals(deal.getDispatcher());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getDispatcher());
    }
}

