/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.offer;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.offer.Offer;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferResult;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferType;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.response.Bid;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DspAvgPriceOffer
implements Offer {
    @Override
    public Map<Bid, OfferResult> offer(Collection<Bid> bids, BidRequest request, Dispatcher dispatcher) {
        HashMap<Bid, OfferResult> offerResultMap = new HashMap<Bid, OfferResult>(bids.size());
        Integer bidModel = request.getBid_model();
        int chargeType = 1;
        int budgetType = 1;
        if (Objects.nonNull(bidModel)) {
            switch (bidModel) {
                case 2: {
                    chargeType = 2;
                    budgetType = 2;
                }
            }
        }
        for (Bid bid : bids) {
            offerResultMap.put(bid, OfferResult.builder().chargeType(chargeType).offer(this.getFixedPrice(dispatcher, bid)).budgetType(budgetType).build());
        }
        return offerResultMap;
    }

    @Override
    public OfferResult offer(Bid bid, BidRequest request, Dispatcher dispatcher) {
        Integer bidModel = request.getBid_model();
        int chargeType = 1;
        int budgetType = 1;
        if (Objects.nonNull(bidModel)) {
            switch (bidModel) {
                case 2: {
                    chargeType = 2;
                    budgetType = 2;
                }
            }
        }
        return OfferResult.builder().chargeType(chargeType).offer(this.getFixedPrice(dispatcher, bid)).budgetType(budgetType).build();
    }

    @Override
    public OfferType offerType() {
        return OfferType.Dsp_Avg_Price;
    }

    private BigDecimal getFixedPrice(Dispatcher dispatcher, Bid bid) {
        DispatcherPriceConfig dispatcherPriceConfig = dispatcher.getBidPriceConfig(bid);
        BigDecimal price = Objects.nonNull(dispatcherPriceConfig) ? (Objects.nonNull(dispatcherPriceConfig.getMediaOfferPrice()) ? dispatcherPriceConfig.getMediaOfferPrice() : dispatcher.getDspAvgPrice()) : dispatcher.getDspAvgPrice();
        return price.movePointRight(2);
    }
}

