/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.offer;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.offer.Offer;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferResult;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferType;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OfferFactory
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(OfferFactory.class);
    private Map<OfferType, Offer> offerMap = new HashMap<OfferType, Offer>();

    public void onApplicationEvent(ApplicationReadyEvent event) {
        Collection offerList = event.getApplicationContext().getBeansOfType(Offer.class).values();
        for (Offer offer : offerList) {
            this.offerMap.put(offer.offerType(), offer);
        }
    }

    public Map<Bid, OfferResult> offer(Collection<Bid> bids, BidRequest request, Dispatcher dispatcher) {
        HashMap<Bid, OfferResult> offerResultMap = new HashMap<Bid, OfferResult>(bids.size());
        for (Bid bid : bids) {
            OfferType offerType = this.getOfferType(dispatcher, dispatcher.getBidPriceConfig(bid));
            this.checkOfferType(offerType, request);
            Offer offer = this.offerMap.get((Object)offerType);
            if (Objects.isNull(offer)) {
                log.warn("offer is null, dispatcher {}", (Object)dispatcher.getId());
                offerResultMap.put(bid, OfferResult.builder().offer(bid.getPrice()).chargeType(bid.getCharge_type()).budgetType(bid.getBudget_type()).build());
                break;
            }
            offerResultMap.put(bid, offer.offer(bid, request, dispatcher));
        }
        return offerResultMap;
    }

    private void checkOfferType(OfferType offerType, BidRequest request) {
        Integer bidModel = Optional.ofNullable(request.getBid_model()).orElse(1);
        if (2 == bidModel && OfferType.Dsp_Avg_Price != offerType) {
            log.error("Media bid-model is cpc, do not support type NONE_Dsp_Avg_Price");
            throw new AdxException(AdxErrEnum.DISPATCHER_ERR);
        }
        if (OfferType.Dsp_Avg_Price_Discount == offerType) {
            log.warn("Warning Type Dsp_Avg_Price_Discount");
        }
    }

    private OfferType getOfferType(Dispatcher dispatcher, DispatcherPriceConfig dispatcherPriceConfig) {
        Integer avgType;
        Integer mediaOfferType;
        Integer n = mediaOfferType = Objects.isNull(dispatcherPriceConfig) ? null : dispatcherPriceConfig.getMediaOfferType();
        if (Objects.nonNull(mediaOfferType)) {
            switch (mediaOfferType) {
                case 0: {
                    return OfferType.Dsp_Avg_Price;
                }
                case 1: {
                    return OfferType.NONE_Dsp_Avg_Price;
                }
                case 2: {
                    return OfferType.Dsp_Avg_Price_Discount;
                }
            }
        }
        if (Objects.isNull(avgType = dispatcher.getAvgType())) {
            BigDecimal avg = dispatcher.getDspAvgPrice();
            if (Objects.isNull(avg)) {
                return OfferType.NONE_Dsp_Avg_Price;
            }
            return OfferType.Dsp_Avg_Price;
        }
        switch (avgType) {
            case 0: {
                return OfferType.Dsp_Avg_Price;
            }
            case 1: {
                return OfferType.NONE_Dsp_Avg_Price;
            }
            case 2: {
                return OfferType.Dsp_Avg_Price_Discount;
            }
        }
        log.error("unknown dispatcher {} avg-type {}", (Object)dispatcher.getId(), (Object)dispatcher.getAvgType());
        throw new AdxException(AdxErrEnum.DISPATCHER_ERR);
    }
}

