/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.request;

import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.position.AdvertPoint;
import com.bxm.adx.common.buy.position.AdvertPointService;
import com.bxm.adx.common.buy.position.Constants;
import com.bxm.adx.common.market.exchange.rebuild.request.AdxBidRequestBuilder;
import com.bxm.adx.common.market.exchange.rebuild.request.RequestBuildAttribute;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.request.Native;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.mcssp.common.enums.app.DockingMethodTypeEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ImpressionBuilder
implements AdxBidRequestBuilder {
    private static final Logger log = LoggerFactory.getLogger(ImpressionBuilder.class);
    private final AdvertPointService advertPointService;
    private static final String DSP_QIHANG = "qihang";
    private static final String DSP_PANGU = "pangu";
    private static final Integer PANGU_CTR = 15;

    public ImpressionBuilder(AdvertPointService advertPointService) {
        this.advertPointService = advertPointService;
    }

    @Override
    public void rebuildAdxBidRequest(BidRequest adxBidRequest, RequestBuildAttribute attribute) {
        Buyer buyer = attribute.getBuyerWrapper().getBuyer();
        Dispatcher dispatcher = attribute.getBuyerWrapper().getDispatcher();
        AdvertPoint advertPoint = this.advertPointService.getAdvertPointByDspId(dispatcher.getDspId().toString(), dispatcher.getDspAppid(), dispatcher.getDspPosid());
        List<Impression> oldImpressions = adxBidRequest.getImps();
        ArrayList<Impression> newImpressions = new ArrayList<Impression>();
        Iterator<Impression> iterator = oldImpressions.iterator();
        if (iterator.hasNext()) {
            Impression impression = iterator.next();
            Impression newImpression = new Impression();
            BeanUtils.copyProperties((Object)impression, (Object)newImpression);
            if (this.needReplaceTagIdByDsp(adxBidRequest, buyer)) {
                newImpression.setTag_id(dispatcher.getDspPosid());
            }
            if (this.needReplaceByAdvertPoint(adxBidRequest)) {
                this.handleAdvertPoint(advertPoint, newImpression, buyer);
            }
            this.handleBidFloor(newImpression, dispatcher, advertPoint, buyer);
            newImpressions.add(newImpression);
        }
        adxBidRequest.setImps(newImpressions);
    }

    private void handleAdvertPoint(AdvertPoint advertPoint, Impression newImpression, Buyer buyer) {
        if (Objects.nonNull(advertPoint)) {
            Integer newImpType;
            Integer positionType;
            AdvertPoint.Size size = advertPoint.getImpressionSize();
            if (Objects.nonNull(size)) {
                newImpression.setH(size.getH());
                newImpression.setW(size.getW());
            }
            if (StringUtils.isNotEmpty((String)advertPoint.getTemplateId())) {
                Native an = new Native();
                if (Objects.nonNull(newImpression.getA_native())) {
                    BeanUtils.copyProperties((Object)newImpression.getA_native(), (Object)an);
                }
                an.setTemplate(advertPoint.getTemplateId());
                newImpression.setA_native(an);
            }
            if (Objects.nonNull(positionType = advertPoint.getPositionType()) && DSP_QIHANG.equalsIgnoreCase(buyer.getCode()) && Objects.nonNull(newImpType = Constants.getPositionSceneTypeByPositionType(positionType))) {
                newImpression.setImp_type(newImpType);
            }
        }
    }

    private void handleBidFloor(Impression newImpression, Dispatcher dispatcher, AdvertPoint advertPoint, Buyer buyer) {
        if (Objects.isNull(advertPoint)) {
            log.warn("dispatcher id: {}, advertPoint is null", (Object)dispatcher.getId());
            throw new AdxException(AdxErrEnum.DISPATCHER_ERR);
        }
        boolean isPangu = this.isPangu(buyer);
        BigDecimal dspRequestFloor = dispatcher.getDspBasePrice();
        Integer costPerType = Optional.ofNullable(advertPoint.getCostPerType()).orElse(1);
        if (Objects.isNull(dspRequestFloor)) {
            if (2 == costPerType) {
                log.warn("Dsp position is cpc, Dut dspBasePrice is null");
                throw new AdxException(AdxErrEnum.DISPATCHER_ERR);
            }
            BigDecimal coefficient = dispatcher.getBasePriceCoefficient();
            dspRequestFloor = Objects.nonNull(coefficient) && coefficient.compareTo(BigDecimal.ZERO) > 0 ? newImpression.getBid_floor().divide(coefficient, 0, 0) : newImpression.getBid_floor();
        } else {
            dspRequestFloor = dspRequestFloor.movePointRight(2);
        }
        dspRequestFloor = dspRequestFloor.setScale(0, 0);
        switch (costPerType) {
            case 2: {
                newImpression.setCpc_bid_floor(dspRequestFloor);
                if (isPangu) break;
                newImpression.setBid_floor(null);
                break;
            }
            case 1: {
                newImpression.setBid_floor(dspRequestFloor);
                newImpression.setCpc_bid_floor(null);
            }
        }
        if (isPangu) {
            this.handlePanguBidFloor(newImpression);
        }
    }

    private boolean isPangu(Buyer buyer) {
        return buyer.getCode().contains(DSP_PANGU);
    }

    private void handlePanguBidFloor(Impression newImpression) {
        if (Objects.isNull(newImpression.getBid_floor()) && Objects.nonNull(newImpression.getCpc_bid_floor())) {
            BigDecimal floor = newImpression.getCpc_bid_floor().multiply(new BigDecimal(PANGU_CTR)).movePointLeft(2).multiply(new BigDecimal(1000));
            newImpression.setBid_floor(floor);
        }
    }

    private boolean needReplaceTagIdByDsp(BidRequest request, Buyer buyer) {
        DockingMethodTypeEnum typeEnum = this.dockingMethodTypeEnum(request);
        if (Objects.isNull(typeEnum)) {
            return true;
        }
        switch (typeEnum) {
            case SDK_OPERATION: {
                return !"scene".equalsIgnoreCase(buyer.getCode());
            }
        }
        return true;
    }

    private boolean needReplaceByAdvertPoint(BidRequest request) {
        DockingMethodTypeEnum typeEnum = this.dockingMethodTypeEnum(request);
        return !DockingMethodTypeEnum.SDK_OPERATION.equals((Object)typeEnum);
    }

    private DockingMethodTypeEnum dockingMethodTypeEnum(BidRequest request) {
        Integer dockingMethodType = request.getDockingMethodType();
        DockingMethodTypeEnum typeEnum = DockingMethodTypeEnum.get((Integer)dockingMethodType);
        return typeEnum;
    }
}

