/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.response.AdxBidResponseBuilder;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PriceConfigResponseBuilder
implements AdxBidResponseBuilder {
    private static final Logger log = LoggerFactory.getLogger(PriceConfigResponseBuilder.class);

    public int getOrder() {
        return 3;
    }

    @Override
    public void rebuildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getDispatcher();
        List<DispatcherPriceConfig> dispatcherPriceConfigs = dispatcher.getDispatcherPriceConfigs();
        if (CollectionUtils.isEmpty(dispatcherPriceConfigs)) {
            return;
        }
        HashMap<String, DispatcherPriceConfig> bidPriceConfigMap = new HashMap<String, DispatcherPriceConfig>();
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            for (Bid bid : seatBid.getBid()) {
                String taskId = bid.getTask_id();
                log.debug("panguResponse ticket:{},taskId:{}", (Object)bid.getAdid(), (Object)taskId);
                DispatcherPriceConfig selectedConfig = dispatcherPriceConfigs.stream().filter(config -> config.getFilterMode() == 1 && CollectionUtils.isNotEmpty(config.getTaskIds()) && config.getTaskIds().contains(taskId)).findFirst().orElseGet(() -> dispatcherPriceConfigs.stream().filter(config -> config.getFilterMode() == 0).findFirst().orElse(null));
                bidPriceConfigMap.put(bid.getId(), selectedConfig);
            }
        }
        dispatcher.setBidPriceConfigMap(bidPriceConfigMap);
    }
}

