/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.creative.review.ReviewCreative;
import com.bxm.adx.common.creative.review.ReviewCreativeDao;
import com.bxm.adx.common.market.exchange.rebuild.response.AdxBidResponseBuilder;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Asset;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.Image;
import com.bxm.adx.common.sell.response.Native;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.common.sell.response.Text;
import com.bxm.adx.common.sell.response.Video;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.dingding.DingDingMessageSender;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ReviewCreativeBuilder
implements AdxBidResponseBuilder {
    private static final Logger log = LoggerFactory.getLogger(ReviewCreativeBuilder.class);
    @Resource
    private ReviewCreativeDao reviewCreativeDao;
    @Resource
    private DingDingMessageSender dingDingMessageSender;
    @Resource
    private JedisFetcher fetcher;
    @Resource
    private JedisUpdater updater;

    @Override
    public void rebuildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getDispatcher();
        List<ReviewCreative> creatives = this.getCreatives(dispatcher);
        if (CollectionUtils.isEmpty(creatives)) {
            return;
        }
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            for (Bid bid : seatBid.getBid()) {
                Native an = bid.getA_native();
                if (!CollectionUtils.isNotEmpty(creatives) || !Objects.nonNull(an) || !CollectionUtils.isNotEmpty(an.getAssets())) continue;
                List<ReviewCreative> reviewCreatives = this.queryReviewCreativeByProduct(creatives, bid, dispatcher);
                ReviewCreative creative = this.randomCreative(reviewCreatives);
                if (Objects.isNull(creative)) {
                    return;
                }
                this.replaceByReviewCreative(bid, creative);
                bid.setCreate_id(creative.getId());
                bid.setAdxCreateId(creative.getId());
            }
        }
    }

    private List<ReviewCreative> getCreatives(Dispatcher dispatcher) {
        List<ReviewCreative> creatives = this.queryReviewCreativeByDispatcher(dispatcher);
        return creatives;
    }

    private ReviewCreative randomCreative(List<ReviewCreative> creatives) {
        if (CollectionUtils.isNotEmpty(creatives)) {
            int r = RandomUtils.nextInt((int)creatives.size());
            return creatives.get(r);
        }
        return null;
    }

    private List<ReviewCreative> queryReviewCreativeByProduct(List<ReviewCreative> creatives, Bid bid, Dispatcher dispatcher) {
        String launchProduct = bid.getLaunchProduct();
        if (StringUtils.isBlank((String)launchProduct)) {
            return creatives;
        }
        List<ReviewCreative> creativesByProduct = creatives.stream().filter(c -> launchProduct.equals(c.getLaunchProduct())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(creativesByProduct)) {
            try {
                String fetch = (String)this.fetcher.fetch(this.getKey(dispatcher, bid.getAdid()), String.class);
                if (StringUtils.isBlank((String)fetch)) {
                    this.dingDingMessageSender.send2(new Message(String.format("\u521b\u610f\u901a\u77e5\uff1a\u6295\u653e\u4ea7\u54c1\u3010%s\u3011\u672a\u5339\u914d\u5230\u7d20\u6750\n \u5e7f\u544a\u4f4dID:%s \n \u5e7f\u544a\u5238ID:%s \n \u5e7f\u544a\u5e73\u53f0ID:%s \n dsp\u5e7f\u544a\u4f4dID:%s \n dsp\u5e94\u7528ID:%s", launchProduct, dispatcher.getPositionId(), bid.getAdid(), dispatcher.getDspId(), dispatcher.getDspPosid(), dispatcher.getDspAppid()), Arrays.asList("18322693791", "15858242186")));
                    this.updater.update(this.getKey(dispatcher, bid.getAdid()), (Object)"1", 180);
                }
            }
            catch (Exception e) {
                log.error(String.format("\u62a5\u8b66\u5931\u8d25\uff0c\u6295\u653e\u4ea7\u54c1\u3010%s\u3011\u672a\u5339\u914d\u5230\u7d20\u6750\uff0cpositionId:%s - ticketId:%s - dspId:%s - dspPosid:%s - dspAppId:%s", launchProduct, dispatcher.getPositionId(), bid.getAdid(), dispatcher.getDspId(), dispatcher.getDspPosid(), dispatcher.getDspAppid()), (Throwable)e);
            }
            throw new AdxException(AdxErrEnum.CREATIVE_NOT_FOUND);
        }
        return creativesByProduct;
    }

    private KeyGenerator getKey(Dispatcher dispatcher, String adid) {
        return () -> KeyBuilder.build((Object[])new Object[]{"DD_ALERT", dispatcher.getPositionId(), adid, dispatcher.getStrategyId()});
    }

    private List<ReviewCreative> queryReviewCreativeByDispatcher(Dispatcher dispatcher) {
        List<Long> creativeIds = dispatcher.getCreativeReviewIdList();
        if (CollectionUtils.isNotEmpty(creativeIds)) {
            List<ReviewCreative> creativeList = this.reviewCreativeDao.queryCreativeListByIds(creativeIds);
            return creativeList;
        }
        return null;
    }

    private void replaceByReviewCreative(Bid bid, ReviewCreative creative) {
        Native bidNative;
        Asset videoAsset;
        String videoUrl;
        String iconUrl;
        String imgUrl;
        String content;
        Native.NativeBuilder builder = Native.builder();
        ArrayList<Asset> assets = new ArrayList<Asset>();
        String title = creative.getTitle();
        if (StringUtils.isNotBlank((String)title)) {
            assets.add(Asset.builder().type(AdxConstants.AssetType.TITLE.getType()).text(Text.builder().text(title).build()).build());
        }
        if (StringUtils.isNotBlank((String)(content = creative.getContent()))) {
            assets.add(Asset.builder().type(AdxConstants.AssetType.CONTENT.getType()).text(Text.builder().text(content).build()).build());
        }
        if (StringUtils.isNotBlank((String)(imgUrl = creative.getImgUrl()))) {
            assets.add(Asset.builder().type(AdxConstants.AssetType.LARGE_IMG.getType()).img(Image.builder().url(imgUrl).w(creative.getImgWeight()).h(creative.getImgHeight()).build()).build());
        }
        if (StringUtils.isNotBlank((String)(iconUrl = creative.getIconUrl()))) {
            assets.add(Asset.builder().type(AdxConstants.AssetType.ICON.getType()).img(Image.builder().url(iconUrl).w(creative.getIconWeight()).h(creative.getIconHeight()).build()).build());
        }
        if (StringUtils.isNotBlank((String)(videoUrl = creative.getVideoUrl())) && Objects.nonNull(videoAsset = (Asset)(bidNative = bid.getA_native()).getAssets().stream().filter(asset -> Objects.nonNull(asset.getVideo())).findFirst().orElse(null))) {
            Video bidVideo = videoAsset.getVideo();
            Video.VideoBuilder video = Video.builder();
            video.url(videoUrl).cover_url(creative.getCoverUrl()).h(creative.getVideoHeight()).w(creative.getVideoWeight()).v_monitor(bidVideo.getV_monitor()).duration(creative.getVideoDuration());
            videoAsset.setVideo(video.build());
            assets.add(videoAsset);
        }
        builder.assets(assets);
        bid.setA_native(builder.build());
    }

    public int getOrder() {
        return 0;
    }
}

