/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.market.exchange.ExchangeResult;
import com.bxm.adx.common.market.filter.DealFilterCondition;
import com.bxm.adx.common.market.filter.Filter;
import com.bxm.adx.common.market.filter.FilterEnum;
import com.bxm.adx.common.openlog.event.internal.AdxFilterEvent;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.utils.MapHelper;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

@Configuration
public class DealFilterFactory
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(DealFilterFactory.class);
    private Collection<Filter> filters;
    private final EventPark eventPark;

    public DealFilterFactory(EventPark eventPark) {
        this.eventPark = eventPark;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.filters = event.getApplicationContext().getBeansOfType(Filter.class).values();
        this.filters = this.filters.stream().sorted(Comparator.comparing(Ordered::getOrder)).collect(Collectors.toList());
    }

    public void filter(MarketOrders orders, ExchangeResult result) {
        List<Deal> deals = result.getDeals();
        if (log.isDebugEnabled()) {
            log.debug("before filter deal list size={}, dispatcher={}", (Object)deals.size(), deals.stream().map(Deal::getDispatcher).map(Dispatcher::getId).collect(Collectors.toSet()));
        }
        if (!CollectionUtils.isEmpty(deals)) {
            Map<Integer, Set<Deal>> trashMap = this.filterDeals(deals, false);
            result.addTrash(trashMap);
        }
        result.addTrash(this.getOvertimeDeal(result, orders.getBidRequest()));
        if (!CollectionUtils.isEmpty(result.getTrash())) {
            this.eventPark.post((EventObject)new AdxFilterEvent(this, orders.getBidRequest(), result.getTrash()));
        }
    }

    public Map<Integer, Set<Deal>> filterDeals(List<Deal> deals, boolean preview) {
        HashSet trash = Sets.newHashSet();
        HashMap trashMap = Maps.newHashMap();
        for (Filter filter : this.filters) {
            if (!this.checkPreview(preview, filter) || this.checkChargeType(deals, filter)) continue;
            String clazzSimpleName = ClassUtils.getUserClass((Object)filter).getSimpleName();
            filter.filter(deals, trash);
            if (!CollectionUtils.isEmpty((Collection)trash)) {
                if (log.isDebugEnabled()) {
                    log.debug("filter {} filter dispatcher={}", (Object)clazzSimpleName, trash.stream().map(Deal::getDispatcher).map(Dispatcher::getId).collect(Collectors.toSet()));
                }
                int filterType = Arrays.stream(FilterEnum.values()).filter(filterEnum -> filterEnum.name().equals(clazzSimpleName)).findFirst().orElse(FilterEnum.Undefined).getType();
                ((Set)MapHelper.get(trashMap, Integer.valueOf(filterType), new HashSet())).addAll(trash);
                deals.removeIf(deal -> trash.contains(deal));
                trash.clear();
            }
            if (!CollectionUtils.isEmpty(deals)) continue;
            break;
        }
        return trashMap;
    }

    private boolean checkChargeType(List<Deal> deals, Filter filter) {
        DealFilterCondition condition = (DealFilterCondition)AnnotationUtils.findAnnotation((Class)ClassUtils.getUserClass((Object)filter), DealFilterCondition.class);
        if (Objects.isNull(condition)) {
            return false;
        }
        int chargeType = condition.chargeType();
        if (chargeType == 0) {
            return false;
        }
        Integer bidModel = deals.stream().map(Deal::getBidRequest).findFirst().orElse(new BidRequest()).getBid_model();
        return bidModel != chargeType;
    }

    private boolean checkPreview(boolean preview, Filter filter) {
        DealFilterCondition condition = (DealFilterCondition)AnnotationUtils.findAnnotation((Class)ClassUtils.getUserClass((Object)filter), DealFilterCondition.class);
        boolean conPreview = false;
        if (Objects.nonNull(condition)) {
            conPreview = condition.preview();
        }
        if (preview) {
            return conPreview;
        }
        return !conPreview;
    }

    private Map<Integer, Set<Deal>> getOvertimeDeal(ExchangeResult exchangeResult, BidRequest bidRequest) {
        Collection<BuyerWrapper> requested = exchangeResult.getBuyers();
        if (CollectionUtils.isEmpty(requested)) {
            return null;
        }
        Set requestedDispatcher = requested.stream().map(BuyerWrapper::getDispatcher).collect(Collectors.toSet());
        Set dealDispatcher = exchangeResult.getDeals().stream().map(Deal::getDispatcher).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(exchangeResult.getTrash())) {
            dealDispatcher.addAll(exchangeResult.getTrash().values().stream().flatMap(Collection::stream).map(Deal::getDispatcher).collect(Collectors.toSet()));
        }
        requestedDispatcher.removeIf(dispatcher -> dealDispatcher.contains(dispatcher));
        if (CollectionUtils.isEmpty(requestedDispatcher)) {
            return null;
        }
        HashSet<Deal> overtime = new HashSet<Deal>(requestedDispatcher.size());
        for (Dispatcher dispatcher2 : requestedDispatcher) {
            overtime.add(new Deal(dispatcher2, bidRequest));
        }
        HashMap trash = Maps.newHashMapWithExpectedSize((int)1);
        trash.put(FilterEnum.Overtime.getType(), overtime);
        return trash;
    }
}

