/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.filter.Filter;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.App;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.warcar.utils.StringHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuGouFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(KuGouFilter.class);
    private static final Map<String, String> KUGOU = new HashMap<String, String>(){
        {
            this.put("6e57208597874fbaa6ed6ac6c5681bef", "807623002011");
        }
    };
    private static final Map<String, String> DEMO = new HashMap<String, String>(){
        {
            this.put("12349dc7e45b4d58b873a87a64756789", "806279004002");
        }
    };
    private static final String SDK_VER = "3.5.2.1603";

    @Override
    public void filter(List<Deal> deals, Set<Deal> trash) {
        BidRequest bidRequest = AdxContextFactory.get().getBidRequest();
        String sdkVer = bidRequest.getSdk_ver();
        if (Objects.nonNull(sdkVer) && StringHelper.isNewVersion((String)SDK_VER, (String)sdkVer)) {
            return;
        }
        App app = bidRequest.getApp();
        if (Objects.nonNull(app)) {
            String appId = app.getId();
            String tagId = bidRequest.getImps().iterator().next().getTag_id();
            if (StringUtils.isNotEmpty((CharSequence)appId) && StringUtils.isNotEmpty((CharSequence)tagId)) {
                if (!this.isKuGou(appId, tagId)) {
                    return;
                }
                deals.removeIf(deal -> {
                    BidResponse response = deal.getBidResponse();
                    if (null == response) {
                        return true;
                    }
                    List<SeatBid> seatBids = response.getSeat_bid();
                    if (CollectionUtils.isEmpty(seatBids)) {
                        return true;
                    }
                    seatBids.removeIf(seatBid -> {
                        List<Bid> bidList = seatBid.getBid();
                        if (CollectionUtils.isEmpty(bidList)) {
                            return true;
                        }
                        bidList.removeIf(b -> StringUtils.isEmpty((CharSequence)b.getDeep_link_url()));
                        return CollectionUtils.isEmpty(bidList);
                    });
                    return CollectionUtils.isEmpty(seatBids);
                });
            }
        }
    }

    private boolean isKuGou(String appId, String tagId) {
        if (KUGOU.containsKey(appId) && KUGOU.get(appId).equals(tagId)) {
            return true;
        }
        return DEMO.containsKey(appId) && DEMO.get(appId).equals(tagId);
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }
}

