/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.monitor;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.market.monitor.MonitorHandler;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.ClickMonitor;
import com.bxm.warcar.utils.UrlHelper;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class Click302Handler
implements MonitorHandler {
    public static final String C_M_URLS = "__c_m_urls__";
    public static final String C_T_URL = "__c_t_url__";
    public static final String SPLIT_FOR_CMURLS = "||";
    private final AdxProperties adxProperties;
    private final BuildAttributeStringMacrosHandler macrosHandler;

    public Click302Handler(AdxProperties adxProperties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.adxProperties = adxProperties;
        this.macrosHandler = macrosHandler;
    }

    @Override
    public void handler(Bid bid, BuildAttribute attribute) {
        String mediaId = attribute.getMediaId();
        boolean needClickMonitor = this.needClickMonitorByMedia(mediaId);
        if (needClickMonitor) {
            String clickThroughUrl302 = this.buildClickUrl302(bid, attribute, needClickMonitor);
            bid.setClick_through_url_302(clickThroughUrl302);
        }
    }

    public int getOrder() {
        return 2;
    }

    private boolean needClickMonitorByMedia(String mediaId) {
        AdxConstants.Media media;
        return StringUtils.isNotEmpty((String)mediaId) && AdxConstants.Media.Bes == (media = AdxConstants.Media.of(Integer.parseInt(mediaId)));
    }

    private String buildClickUrl302(Bid bid, BuildAttribute buildAttribute, boolean needClickMonitor) {
        String url = this.adxProperties.getAdsCounter().getAdx302Url(true, false);
        String replacedUrl = this.macrosHandler.replaceAll(url, buildAttribute);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)replacedUrl);
        builder.replaceQueryParam(C_T_URL, new Object[]{this.getCtUrl(bid.getClick_through_url())});
        if (needClickMonitor) {
            builder.replaceQueryParam(C_M_URLS, new Object[]{this.getCmUrls(bid.getClick_monitors())});
        }
        return builder.build().toString();
    }

    private String getCmUrls(List<ClickMonitor> clickMonitors) {
        StringBuilder s = new StringBuilder();
        for (ClickMonitor clickMonitor : clickMonitors) {
            s.append(clickMonitor.getClick_monitor_url()).append(SPLIT_FOR_CMURLS);
        }
        return UrlHelper.urlEncode((String)s.toString());
    }

    private String getCtUrl(String clickThroughUrl) {
        if (StringUtils.isNotBlank((String)clickThroughUrl)) {
            return UrlHelper.urlEncode((String)clickThroughUrl);
        }
        return clickThroughUrl;
    }
}

