/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.monitor;

import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.market.monitor.MonitorHandler;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

@Configuration
public class MonitorWrapper
implements ApplicationListener<ApplicationReadyEvent> {
    private Collection<? extends MonitorHandler> monitorHandlers;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        Map map = event.getApplicationContext().getBeansOfType(MonitorHandler.class);
        this.monitorHandlers = map.values().stream().sorted(Comparator.comparing(Ordered::getOrder)).collect(Collectors.toList());
    }

    public void monitorWrapper(BidResponse response) {
        BidRequest bidRequest = AdxContextFactory.get().getBidRequest();
        BuildAttribute buildAttribute = new BuildAttribute().setAdxResponse(response).setSspRequest(bidRequest).setMediaId(bidRequest.getMediaId());
        for (SeatBid seatBid : response.getSeat_bid()) {
            buildAttribute.setDspId(Objects.nonNull(seatBid.getDspId()) ? seatBid.getDspId() : null);
            buildAttribute.setConfigId(Objects.nonNull(seatBid.getConfigId()) ? seatBid.getConfigId() : null);
            buildAttribute.setStrategyId(Objects.nonNull(seatBid.getStrategyId()) ? seatBid.getStrategyId() : null);
            buildAttribute.setAlgoFlowControlBucket(Objects.nonNull(seatBid.getAlgoFlowControlBucket()) ? seatBid.getAlgoFlowControlBucket() : null);
            for (Bid bid : seatBid.getBid()) {
                buildAttribute.setDTagId(Objects.nonNull(bid.getTag_id()) ? bid.getTag_id() : null);
                for (MonitorHandler monitorHandler : this.monitorHandlers) {
                    monitorHandler.handler(bid, buildAttribute);
                }
            }
        }
    }
}

