/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.micrometer.interceptor;

import com.bxm.warcar.utils.SafeMapHelper;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AdxRequestsInterceptor
implements MeterBinder,
HandlerInterceptor {
    private final ThreadLocal<Long> threadLocal = ThreadLocal.withInitial(new Supplier<Long>(){

        @Override
        public Long get() {
            return System.currentTimeMillis();
        }
    });
    private final ConcurrentHashMap<String, Timer> map = new ConcurrentHashMap();
    private MeterRegistry registry;

    public void bindTo(MeterRegistry registry) {
        this.registry = registry;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.threadLocal.set(System.nanoTime());
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        try {
            Long start = this.threadLocal.get();
            final String contextPath = request.getRequestURI();
            final String status = response.getStatus() + "";
            Timer timer = (Timer)SafeMapHelper.get(this.map, (Object)(contextPath + "-" + status), (SafeMapHelper.InitializingValue)new SafeMapHelper.InitializingValue<Timer>(){

                public Timer initializing() {
                    return Timer.builder((String)"adx.requests").tag("path", contextPath).tag("status", status).register(AdxRequestsInterceptor.this.registry);
                }
            });
            if (Objects.nonNull(timer)) {
                timer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
        }
        finally {
            this.threadLocal.remove();
        }
    }
}

