/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.DotEventControlProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.openlog.event.internal.DspBidEvent;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DotDspBidEventListener
implements EventListener<DspBidEvent> {
    private final int EXPIRE_SECONDS_12_HOURS = 43200;
    private final int EXPIRE_SECONDS_24_HOURS = 86400;
    private final Counter counter;
    private OpenLogClient openLogClient;
    private final AdxProperties properties;
    private final BuildAttributeStringMacrosHandler macrosHandler;

    public DotDspBidEventListener(Counter counter, AdxProperties properties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.counter = counter;
        this.properties = properties;
        this.macrosHandler = macrosHandler;
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(DspBidEvent event) {
        this.handleDspAvgFill(event);
        if (Math.abs(event.getSspRequest().getId().hashCode() % 100) >= this.properties.getDotSimplingPercent()) {
            return;
        }
        String url = this.properties.getOpenLog().create(true, 3, OpenlogConstants.WITHOUT_MACROS_INNER);
        BuildAttribute attribute = new BuildAttribute(3).setDspId(event.getDspId()).setSspRequest(event.getSspRequest()).setAdxRequest(event.getAdxRequest()).setDspResponse(event.getDspResponse()).setStrategyId(event.getStrategyId());
        url = this.macrosHandler.replaceAll(url, attribute);
        this.openLogClient.asyncRequest(url);
    }

    private void handleDspAvgFill(DspBidEvent event) {
        LocalDateTime now;
        String dspTagId;
        String dspId = event.getDspId().toString();
        DotEventControlProperties control = this.needControl(dspId, dspTagId = event.getAdxRequest().getImps().iterator().next().getTag_id(), now = LocalDateTime.now());
        if (Objects.isNull(control)) {
            return;
        }
        KeyGenerator sectionKey = AdxKeyGenerator.Counter.getDspPositionFillBySection((String)control.getId(), (String)control.getSectionId(now), (String)dspId, (String)dspTagId);
        KeyGenerator controlKey = AdxKeyGenerator.Counter.getDspPositionFillByControl((String)control.getId(), (String)dspId, (String)dspTagId);
        this.counter.incrementAndGet(sectionKey, 43200);
        this.counter.incrementAndGet(controlKey, 86400);
    }

    private DotEventControlProperties needControl(String dspId, String dspTagId, LocalDateTime now) {
        List<DotEventControlProperties> controls = this.properties.getDotEventControls();
        if (CollectionUtils.isEmpty(controls)) {
            return null;
        }
        Optional<DotEventControlProperties> optional = controls.stream().filter(p -> Objects.nonNull(p.getMt()) && 3 == p.getMt()).filter(p -> p.getDspId().equals(dspId)).filter(p -> p.getDspPositionId().equals(dspTagId)).filter(p -> now.isAfter(p.getStart()) && now.isBefore(p.getEnd())).findFirst();
        return optional.isPresent() ? optional.get() : null;
    }
}

