/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.openlog.event.internal.MediaRequestEvent;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.adx.common.sell.request.Geo;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Configuration
public class DotMediaRequestEventListener
implements EventListener<MediaRequestEvent> {
    private OpenLogClient openLogClient;
    private final AdxProperties properties;
    private final BuildAttributeStringMacrosHandler macrosHandler;
    private final double EPSILON = 0.01;

    public DotMediaRequestEventListener(AdxProperties properties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.properties = properties;
        this.macrosHandler = macrosHandler;
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(MediaRequestEvent event) {
        if (Math.abs(event.getSspRequest().getId().hashCode() % 100) >= this.properties.getDotSimplingPercent()) {
            return;
        }
        String url = this.properties.getOpenLog().create(true, 1, this.customizeParams(event), "dspid", "chgtypm", "chgtypd");
        BuildAttribute attribute = new BuildAttribute(1).setSspRequest(event.getSspRequest());
        url = this.macrosHandler.replaceAll(url, attribute);
        this.openLogClient.asyncRequest(url);
    }

    private MultiValueMap<String, String> customizeParams(MediaRequestEvent event) {
        BidRequest request = event.getSspRequest();
        Geo geo = request.getGeo();
        if (Objects.nonNull(geo)) {
            Double lat = geo.getLat();
            Double lon = geo.getLon();
            if (Objects.nonNull(lat) && Objects.nonNull(lon)) {
                if (this.isZero(lat) || this.isZero(lon)) {
                    return null;
                }
                LinkedMultiValueMap customizeParams = new LinkedMultiValueMap();
                customizeParams.add((Object)"geo", (Object)StringUtils.join((Object[])new String[]{String.format("%.2f", lat), String.format("%.2f", lon)}, (String)","));
                return customizeParams;
            }
        }
        return null;
    }

    private boolean isZero(double value) {
        return Math.abs(value) < 0.01;
    }
}

