/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.report;

import com.bxm.adx.common.report.ReportClient;
import com.bxm.adx.common.report.ReportFallback;
import com.bxm.adx.common.utils.HttpClientUtils;
import com.bxm.warcar.utils.NamedThreadFactory;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class DefaultHttpClientReportClient
implements ReportClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpClientReportClient.class);
    private final ThreadPoolExecutor executor;
    private final HttpClient httpClient;
    private Timer timer;
    private Counter success;
    private Counter fail;

    private DefaultHttpClientReportClient(ThreadPoolExecutor executor, int maxTotal, int defaultMaxPerRoute, int connectionRequestTimeout, int connectTimeout, int socketTimeout) {
        this.executor = executor;
        this.httpClient = HttpClientUtils.createHttpClient(maxTotal, defaultMaxPerRoute, connectionRequestTimeout, connectTimeout, socketTimeout, true);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void bindTo(MeterRegistry registry) {
        Class clazz = ClassUtils.getUserClass((Object)this);
        this.registerGauge(registry, this, clazz);
        this.registerTimer(registry, this, clazz);
        this.registerCounter(registry, this, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean request(String url, Header ... headers) throws IOException {
        long start = System.nanoTime();
        HttpResponse response = null;
        try {
            HttpGet get = new HttpGet(url);
            if (ArrayUtils.isNotEmpty((Object[])headers)) {
                get.setHeaders(headers);
            }
            boolean bl = (response = this.httpClient.execute((HttpUriRequest)get)).getStatusLine().getStatusCode() == 200;
            return bl;
        }
        finally {
            if (Objects.nonNull(response)) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            if (Objects.nonNull(this.timer)) {
                this.timer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
        }
    }

    @Override
    public void asyncRequest(String url, Consumer<ReportFallback> fallback, Header ... headers) {
        this.executor.execute(() -> {
            block5: {
                try {
                    if (!this.request(url, headers)) {
                        this.fail.increment();
                        if (Objects.nonNull(fallback)) {
                            fallback.accept(ReportFallback.builder().url(url).headers(headers).build());
                        }
                    } else {
                        this.success.increment();
                    }
                }
                catch (IOException e) {
                    this.fail.increment();
                    if (!Objects.nonNull(fallback)) break block5;
                    fallback.accept(ReportFallback.builder().url(url).headers(headers).exception(e).build());
                }
            }
        });
    }

    @Override
    public void asyncRequest(String url, Header ... headers) {
        this.asyncRequest(url, (Consumer<ReportFallback>)null, (Header[])null);
    }

    @Override
    public int queueSize() {
        return this.executor.getQueue().size();
    }

    @Override
    public void close() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                log.warn("This executor was forced terminated!");
            }
        }
        catch (InterruptedException e) {
            log.error("awaitTermination: ", (Throwable)e);
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    private void registerGauge(MeterRegistry registry, ReportClient client, Class<?> clazz) {
        Gauge.builder((String)"ReportClient.queue", (Object)0, value -> client.queueSize()).tags(new String[]{"name", clazz.getName()}).register(registry);
    }

    private void registerTimer(MeterRegistry registry, ReportClient client, Class<?> clazz) {
        this.timer = Timer.builder((String)"ReportClient.timer").tag("name", clazz.getName()).register(registry);
        log.info("Registering ReportClient {} timer meter successful.", (Object)client);
    }

    private void registerCounter(MeterRegistry registry, ReportClient client, Class<?> clazz) {
        this.success = Counter.builder((String)"ReportClient.counter").tag("name", "success").register(registry);
        this.fail = Counter.builder((String)"ReportClient.counter").tag("name", "fail").register(registry);
        log.info("Registering ReportClient {} counter meter successful.", (Object)client);
    }

    public static class Builder {
        private int maxTotal = 200;
        private int defaultMaxPerRoute = 20;
        private int connectionRequestTimeout = 100;
        private int connectTimeout = 200;
        private int socketTimeout = 500;
        private ThreadPoolExecutor executor;

        private Builder() {
            int processors = Runtime.getRuntime().availableProcessors();
            int max = 10000;
            this.executor = new ThreadPoolExecutor(processors, processors, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(max), (ThreadFactory)new NamedThreadFactory("report-client"));
        }

        public DefaultHttpClientReportClient build() {
            return new DefaultHttpClientReportClient(this.executor, this.maxTotal, this.defaultMaxPerRoute, this.connectionRequestTimeout, this.connectTimeout, this.socketTimeout);
        }

        public Builder setMaxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
            return this;
        }

        public Builder setDefaultMaxPerRoute(int defaultMaxPerRoute) {
            this.defaultMaxPerRoute = defaultMaxPerRoute;
            return this;
        }

        public Builder setConnectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder setExecutor(ThreadPoolExecutor executor) {
            this.executor = executor;
            return this;
        }
    }
}

