package com.bxm.adx.common;

/**
 * ADX埋点行为类型及参数
 * 详情对照内部OpenLog文档
 *
 * @author fgf
 * @date 2022/6/1
 **/
public class OpenlogConstants {
    public interface Macros {
        String MT = "__MT__";
        String SPM = "__SPM__";
        String VER = "__VER__";
        String BXMID = "__BXMID__";
        String TIMESTAMP_S = "__TIMESTAMP_S__";
        String TIMESTAMP = "__TIMESTAMP__";
        String BIDID = "__BID_COMMON_REQUEST_ID__";
        String BIDIDC = "__BID_COMMON_REQUEST_ID_C__";
        String TAGID = "__TAGID__";
        String PRICE = "__PRICE__";
        String APPID = "__APPID__";
        String CONFIGID = "__CONFIGID__";
        String DSPID = "__DSPID__";
        String DAPPID = "__DAPPID__";
        String DTAGID = "__DTAGID__";
        String DPRICE = "__DSP_PRICE__";
        String DSP_WIN_PRICE = "__DSP_WIN_PRICE__";
        String MEDIA_ID = "__MEDIA_ID__";
        String CHARGE_TYPE_MEDIA = "__CHARGE_TYPE_MEDIA__";
        String CHARGE_TYPE_DSP = "__CHARGE_TYPE_DSP__";
        String DEVICE = "__DEVICE__";
        String ENC_MODEL = "__ENC_MODEL__";
        String XREQW = "__X_REQ_W__";
        String APP_PACKAGE_NAME = "__APP_PACKAGE_NAME__";
        String REQUEST_SIZE = "__REQUEST_SIZE__";
        //广点通相关macros
        String DOWN_X = "__DOWN_X__";
        String DOWN_Y = "__DOWN_Y__";
        String UP_X = "__UP_X__";
        String UP_Y = "__UP_Y__";
        String AD_WIDTH = "__AD_WIDTH__";
        String AD_HEIGHT = "__AD_HEIGHT__";
        String CREATE_ID = "__CREATE_ID__";
        String RISK_CONTROL = "__R_CTRL__";
        String IP = "__IP__";
        String DISPATCHER_ID = "__DISPATCHER_ID__";
        String NBR = "__NBR__";
        String STRATEGY_ID = "__STRATEGY_ID__";
        String ALGO_FC_BUCKET = "__AG_FC_B__";
        String CREATIVES = "__CREATIVES__";
        String TASK_ID = "__TASK_ID__";
        String DISPATCHER_PC_IC = "__DPC_ID__";
        String AD_ID = "__AD_ID__";
        String DSP_WIN_PRICE_MODEL = "__DSP_WIN_PRICE_MODEL__";
        String DSP_PRICE_CONFIG = "__DSP_PRICE_CONFIG__";
        String USL = "__USL__";
        String EXP_ID = "__EXP_ID__";
        String EXT_TAG_ID = "__EXT_TAG_ID__";
    }

    /**
     * MT
     */
    public interface Mt {
        /**
         * SSP/直媒请求
         */
        int MEDIA_REQUEST_MT = 1;
        /**
         * ADX请求DSP
         */
        int ADX_REQUEST_MT = 2;
        /**
         * DSP响应
         */
        int DSP_RESPONSE_MT = 3;
        /**
         * ADX响应
         */
        int ADX_RESPONSE_MT = 4;
        /**
         * 曝光
         */
        int IMP_MT = 5;
        /**
         * 点击
         */
        int CLICK_MT = 6;
        /**
         * 胜出
         */
        int WIN_MT = 7;
        /**
         * 落地页302
         */
        int CLICK_302_MT = 8;
        /**
         * dsp赢价二价
         */
        int DSP_WIN_SECOND_AUCTION_MT = 9;
        /**
         * deeplink开始
         */
        int DP_START_MT = 10;
        /**
         * deeplink成功
         */
        int DP_SUCCESS_MT = 11;
        /**
         * deeplink失败
         */
        int DP_FAIL_MT = 12;
        /**
         * 下载开始
         */
        int DOWN_START = 15;
        /**
         * 下载完成
         */
        int DOWN_FINISH = 16;
        /**
         * 安装开始
         */
        int INSTALL_START = 17;
        /**
         * 安装完成
         */
        int INSTALL_FINISH = 18;
        /**
         * 参竞失败
         */
        int BID_FAIL = 999;
        /**
         * adx过滤
         */
        int ADX_FILTER = 41;
        /**
         * adx过滤
         */
        int ADX_DISPATCHER_FILTER = 42;
        /**
         * 流量分配价格配置过滤
         */
        int DISPATCHER_PRICE_CONFIG_FILTER = 43;
        /**
         * dsp不参竞原因
         */
        int DSP_NBR_MT = 31;

        /**
         * dsp响应启航高质量埋点
         */
        int DSP_BID_USL = 32;
    }

    /**
     * 内部埋点排除的字段
     */
    public static final String[] WITHOUT_MACROS_INNER = new String[]{"chgtypm", "chgtypd", "encm", "xreqw", "down_x", "down_y", "up_x", "up_y", "ad_width", "ad_height", "rctrl", "dwm", "dprc", "usl"};
    /**
     * 外部埋点排除的字段
     */
    public static final String[] WITHOUT_MACROS_OUT = new String[]{"chgtypm", "chgtypd", "encm", "price", "xreqw", "down_x", "down_y", "up_x", "up_y", "ad_width", "ad_height", "dwm", "dprc"};
    /**
     * 保留的字段，除外全部排除
     */
    public static final String[] WITH_MACROS = new String[]{"mt", "time", "bidid", "tagid", "dspid", "dtagid", "medid"};

    /**
     * dsp响应启航高质量埋点需要保留的参数
     */
    public static final String[] DSP_BID_USL_WITH_MACROS = new String[]{"mt", "time", "bidid","device","exp_id"};

    public interface MacrosCustomizeParams {
        String ADX_FILTER = "fil";
        String ADX_DISPATCHER_FILTER = "dfil";
        String BID_CREATIVES = "creatives";
        String SERVER_REPORT_RESULT = "srr";
        String SERVER_REPORT_TIME = "srtime";
        String DSP_WIN_PRICE = "dprwin";
        String DISPATCHER_PRICE_CONFIG_FILTER = "dpcfil";
    }
}
