package com.bxm.adx.common;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * @author fgf
 * @date 2023/6/19
 **/
@Data
@ConfigurationProperties(prefix = "adx.replace-creative")
public class ReplaceCreativeProperties {
    /**
     * 启用替换素材的限制
     */
    private LimitConfig limitConfig;
    /**
     * 边缘程序配置
     */
    private ErConfig erConfig;

    /**
     * 完全使用替换素材的媒体
     */
    private List<String> fullUseMediaIdList;

    @Data
    public static class LimitConfig {
        /**
         * 限制媒体
         */
        private List<String> mediaIdList;
        /**
         * 限制省份
         */
        private List<String> provinceCodeList;
    }

    @Data
    public static class ErConfig {
        /**
         * 边缘程序专用域名
         */
        private String newHost;
        /**
         * 支持er的媒体
         */
        private List<String> mediaIdList;
    }
}
