package com.bxm.adx.common;

import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * @author fgf
 * @date 2023/4/13
 **/
@Data
@ConfigurationProperties(prefix = "adx.server-report")
public class ServerReportProperties {
    /**
     * 需要服务端上报的媒体
     */
    private List<MediaConfig> media = Lists.newArrayList();
    /**
     * 支持服务端上报的dsp
     */
    private List<String> dspIds = Lists.newArrayList();
    /**
     * 广告主域名
     */
    private List<String> domains = Lists.newArrayList();
    /**
     * 存放需要上报的监测的db
     */
    private int queueDb = 2;
    /**
     * 临时存放可能需要上报的监测的过期时间
     */
    private int expire = 24 * 3600;

    @Data
    public static class MediaConfig {
        /**
         * dspId
         */
        private String id;
        /**
         * 广告主域名
         */
        private List<String> appIds;
        /**
         * 支持的条数
         */
        private Integer num;
    }
}
