package com.bxm.adx.common.autoconfigure;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.PanguBackupProperties;
import com.bxm.adx.common.ReplaceCreativeProperties;
import com.bxm.adx.common.log.ByteLogger;
import com.bxm.adx.common.log.FileByteLogger;
import com.bxm.adx.common.micrometer.interceptor.AdxRequestsInterceptor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @since 2019-12-12
 */
@Configuration
@EnableConfigurationProperties({AdxProperties.class, PanguBackupProperties.class, ReplaceCreativeProperties.class})
public class AdxAutoConfiguration {
    @Bean
    public AdxRequestsInterceptor adxRequestsInterceptor() {
        return new AdxRequestsInterceptor();
    }

    @Bean
    public ByteLogger fileByteLogger() {
        return new FileByteLogger();
    }
}
