package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.caching.Id;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.request.Impression;
import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

/**
 * Dispatcher查询过滤条件参数对象
 *
 * @author fgf
 * @date 2022/9/20
 **/
@Data
@Builder
public class DispatcherContext<T extends Id> {
    private BidRequest request;
    private Position position;
    /**
     * 总集合
     */
    private Collection<T> values;
    private Boolean sdkConcurrentModel;
    private Set<String> userCrowds;
    private String algoFlowControlBucket;

    public boolean getSdkConcurrentModel() {
        if (Objects.isNull(sdkConcurrentModel)) {
            sdkConcurrentModel = initSdkConcurrentModel();
        }
        return sdkConcurrentModel;
    }

    private boolean initSdkConcurrentModel() {
        Impression impression = request.getImps().iterator().next();
        BigDecimal minPrice = impression.getBid_floor();
        BigDecimal maxPrice = impression.getBid_top();
        return Objects.nonNull(minPrice) && Objects.nonNull(maxPrice) && (maxPrice.compareTo(BigDecimal.ZERO) > 0);
    }
}
