package com.bxm.adx.common.buy.position;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author fgf
 * @date 2022/7/15
 **/
@Service
@Slf4j
public class AdvertPointServiceImpl implements AdvertPointService{
    private final AdvertPointCached advertPointCached;

    public AdvertPointServiceImpl(AdvertPointCached advertPointCached) {
        this.advertPointCached = advertPointCached;
    }

    @Override
    public AdvertPoint getAdvertPointByDspId(String dspId, String dspAppId, String dspPositionId) {
        AdvertPoint advertPoint = advertPointCached.getAdPoint(dspId, dspAppId, dspPositionId);
        return advertPoint;
    }
}
