package com.bxm.adx.common.cipher;

import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;

/**
 * @author fgf
 * @date 2022-02-25
 * @since 1.0
 */
public class PriceCipher {

    /**
     * 解密赢价数据<br/>
     * AES-128 ECB
     * @param win 赢价(需要经过URLDECODE, 走正常流程已经在之前的步骤里做过了)
     * @param key private key
     * @return win price
     */
    public static String decryptWin(String win, String key) throws Exception {
        byte[] decodeBase64 = Base64.decodeBase64(win);
        byte[] keys = key.getBytes(StandardCharsets.UTF_8);

        SecretKeySpec skeySpec = new SecretKeySpec(keys, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(Cipher.DECRYPT_MODE, skeySpec);

        byte[] original = cipher.doFinal(decodeBase64);
        return new String(original, StandardCharsets.UTF_8);
    }

    public static String encryptWin(String win, String key) throws Exception {
        byte[] keys = key.getBytes(StandardCharsets.UTF_8);

        SecretKeySpec skeySpec = new SecretKeySpec(keys, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(Cipher.ENCRYPT_MODE, skeySpec);

        byte[] original = cipher.doFinal(win.getBytes(StandardCharsets.UTF_8));
        return new String(Base64.encodeBase64(original));
    }

    public static void main(String[] args) throws Exception {

//        System.out.println(encryptWin("123.56", "0123456789acdefh"));
        System.out.println(decryptWin("2LrXwr1PXNifX2J19oLiNg", "1a2b3c4d5e6f7g8h"));
    }
}
