package com.bxm.adx.common.collection;

import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.constant.enums.AppPlatformTypeEnum;
import com.bxm.adx.facade.constant.enums.DevOsEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.mccms.facade.model.pushable.PositionCollectionCacheVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * <p>
 * 广告位集合 服务实现
 * </p>
 *
 * @author zhengwangeng
 * @since 2021-9-27
 */
@Slf4j
@Configuration
public class PositionCollectionServiceImpl implements PositionCollectionService {
    
    private final PositionCollectionDao positionCollectionDao;

    public PositionCollectionServiceImpl(PositionCollectionDao positionCollectionDao) {
        this.positionCollectionDao = positionCollectionDao;
    }

    @Override
    public PositionCollectionCacheVO getByPositionId(PositionCollectionRequest positionCollectionRequest) {
        String positionId = positionCollectionRequest.getPositionId();
        PositionCollectionCacheVO position = positionCollectionDao.getByPositionId(positionId);
        if (null == position) {
            if (log.isDebugEnabled()) {
                log.debug("广告位SDK配置中，没有获取到：{} 的广告位信息。", positionId);
            }
            return position;
        }
        if (position.getPositionScene().byteValue() != positionCollectionRequest.getPositionScene()) {
            throw new AdxException(AdxErrEnum.POSITION_SCENE_MISMATCH);
        }
        AppPlatformTypeEnum platformTypeEnum = AppPlatformTypeEnum.of(position.getPlatformType());
        DevOsEnum osEnum = DevOsEnum.of(positionCollectionRequest.getOs());
        switch (osEnum) {
            case IOS:
                if (AppPlatformTypeEnum.IOS != platformTypeEnum) {
                    throw new AdxException(AdxErrEnum.POSITION_OS_MISMATCH);
                }
                break;
            case ANDROID:
                if (AppPlatformTypeEnum.ANDROID != platformTypeEnum) {
                    throw new AdxException(AdxErrEnum.POSITION_OS_MISMATCH);
                }
                break;
        }
        return position;
    }

}
