package com.bxm.adx.common.log;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import org.springframework.stereotype.Component;

/**
 * @author jingyu.li
 * @date 2024-03-05
 */
@Component
public class AdxDataLogMonitor implements MeterBinder {

    private MeterRegistry registry;

    @Override
    public void bindTo(MeterRegistry registry) {
        this.registry = registry;
    }

    /**
     * 原始响应监控
     */
    public void originalResponseMonitor(String positionId,Long dspId,String dspPosid) {
        registry.counter("DSP_ORIGINAL_RESPONSE","key",positionId+"_"+dspId+"_"+dspPosid).increment();
    }

    /**
     * 响应监控
     */
    public void responseMonitor(String positionId,Long dspId,String dspPosid) {
        registry.counter("CANJING_RESPONSE","key",positionId+"_"+dspId+"_"+dspPosid).increment();
    }

    /**
     * 请求监控
     */
    public void requestMonitor(String positionId) {
        registry.counter("MEDIA_REQUEST","key",positionId).increment();
    }

}
