package com.bxm.adx.common.log.buriedSwitch;

import com.bxm.warcar.utils.MapHelper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

/**
 * @author fgf
 * @date 2024/3/1
 **/
@Configuration
public class BuriedSwitchCached implements BuriedSwitchChangeHandler {

    private final ConcurrentHashMap<String, CopyOnWriteArraySet<String>> positionMap = new ConcurrentHashMap<>();

    @Override
    public void doUpdate(BuriedSwitch old, BuriedSwitch latest) {
        if (isExecuteUpdateAndDoDelete(old, latest)) {
            if (latest.getOpened() == BuriedSwitch.OPENED_1) {
                String positionId = latest.getPositionId();
                String dspInfo = latest.getDspId() + "-" + latest.getDspPosid();
                MapHelper.get(positionMap, positionId, new CopyOnWriteArraySet<>()).add(dspInfo);
            }
        }
    }

    @Override
    public void doDelete(BuriedSwitch old) {
        String positionId = old.getPositionId();
        String dspInfo = old.getDspId() + "-" + old.getDspPosid();
        MapHelper.get(positionMap, positionId, new CopyOnWriteArraySet<>()).remove(dspInfo);
        if (CollectionUtils.isEmpty(positionMap.get(positionId))) {
            positionMap.remove(positionId);
        }
    }

    public boolean contains(String positionId) {
        return positionMap.containsKey(positionId);
    }
}
