package com.bxm.adx.common.market.exchange;

import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.utils.MapHelper;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @author fgf
 * @date 2023/3/26
 **/
@Data
public class ExchangeResult {
    private List<Deal> deals = new ArrayList<>();
    private Map<Integer, Set<Deal>> trash;
    private Collection<BuyerWrapper> buyers = new ArrayList<>();

    public void addTrash(Map<Integer, Set<Deal>> trashMap) {
        if (CollectionUtils.isEmpty(trashMap)) {
            return;
        }
        if (CollectionUtils.isEmpty(trash)) {
            trash = trashMap;
            return;
        }

        for (Map.Entry<Integer, Set<Deal>> entry : trashMap.entrySet()) {
            Set<Deal> val = entry.getValue();
            if (CollectionUtils.isEmpty(val)) {
                continue;
            }
            MapHelper.get(trash, entry.getKey(), new HashSet<>()).addAll(val);
        }
    }

    public boolean exchangeSuccess() {
        return !CollectionUtils.isEmpty(deals);
    }
}
