package com.bxm.adx.common.market.exchange.rebuild.filter;

import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import org.springframework.core.Ordered;

import java.util.Collection;

/**
 * 流量分配价格配置过滤器
 *
 * @author fgf
 * @date 2024/5/31
 **/
public interface DispatcherPriceConfigFilter extends Ordered {
    /**
     * 根据Bid过滤价格配置，被过滤的配置从priceConfigs中移除
     * @param priceConfigs
     * @param bid
     * @param seatBid
     * @param attribute
     */
    void filter(Collection<DispatcherPriceConfig> priceConfigs, Bid bid, SeatBid seatBid, ResponseBuildAttribute attribute);
}
