package com.bxm.adx.common.market.exchange.rebuild.filter;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

/**
 * dsp最低出价过滤，过滤掉出价小于配置的最低价
 * @author jingyu.li
 * @date 2024-06-11
 */
@Slf4j
@Configuration
public class LowPriceDispatcherPriceConfigFilter implements DispatcherPriceConfigFilter{

    @Override
    public int getOrder() {
        return 40;
    }

    @Override
    public void filter(Collection<DispatcherPriceConfig> priceConfigs, Bid bid, SeatBid seatBid, ResponseBuildAttribute attribute) {
        boolean isCpc = isCpc(bid);
        BigDecimal price;
        if (!isCpc) {
            price = bid.getPrice();
        } else {
            price = bid.getBid();
        }
        if (Objects.isNull(price)) {
            return;
        }
        BigDecimal finalPrice = price;
        priceConfigs.removeIf(config -> config.getFilterDspPrice() != null && finalPrice.compareTo(config.getFilterDspPrice().movePointRight(2)) < 0);
    }

    private boolean isCpc(Bid bid) {
        if (Objects.isNull(bid.getCharge_type())) {
            return false;
        }
        return AdxConstants.BidModel.SUPPORT_CPC == bid.getCharge_type();
    }
}
