package com.bxm.adx.common.market.exchange.rebuild.offer;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.response.Bid;

import java.util.Collection;
import java.util.Map;

/**
 * 对媒体出价的不同实现
 *
 * @author fgf
 * @date 2023/1/10
 **/
public interface Offer {
    /**
     * 出价
     *
     * @param bids
     * @param request
     * @param dispatcher
     * @return
     */
    @Deprecated
    default Map<Bid, OfferResult> offer(Collection<Bid> bids, BidRequest request, Dispatcher dispatcher) {return null;}

    /**
     * 出价
     * @param bid
     * @param request
     * @param dispatcher
     * @param priceConfig
     * @return
     */
    OfferResult offer(Bid bid, BidRequest request, Dispatcher dispatcher, DispatcherPriceConfig priceConfig);

    /**
     * 出价类型
     * @return
     */
    OfferType offerType();
}
