package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.market.exchange.rebuild.filter.DispatcherPriceConfigFilterFactory;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.warcar.integration.pair.Pair;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

/**
 * @author fgf
 * @date 2023/1/9
 **/
@Configuration
public class AdxBidResponseBuildFactory implements ApplicationListener<ApplicationReadyEvent> {
    private List<AdxBidResponseBuilder> builderList = new ArrayList<>();
    private final DispatcherPriceConfigFilterFactory dispatcherPriceConfigFilterFactory;
    private final Pair pair;
    private final String KEY = "test.position.list";
    public AdxBidResponseBuildFactory(DispatcherPriceConfigFilterFactory dispatcherPriceConfigFilterFactory, Pair pair) {
        this.dispatcherPriceConfigFilterFactory = dispatcherPriceConfigFilterFactory;
        this.pair = pair;
    }

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        builderList.addAll(event.getApplicationContext().getBeansOfType(AdxBidResponseBuilder.class).values());
        builderList.sort(Comparator.comparingInt(Ordered::getOrder));
    }

    public BidResponse buildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        //定制开启广告位使用新功能
        Set<String> positions = pair.get(KEY).ofHashSet();
        String positionId = attribute.getDispatcher().getPositionId();
        if (CollectionUtils.isNotEmpty(positions) && positions.contains(positionId)) {
            dispatcherPriceConfigFilterFactory.filter(bidResponse, attribute);
        }
        builderList.forEach(builder -> builder.rebuildAdxBidResponse(bidResponse, attribute));
        return bidResponse;
    }

    private BidResponse initAdxBidResponse(BidResponse bidResponse) {
        BidResponse adxBidResponse = new BidResponse();
        BeanUtils.copyProperties(bidResponse, adxBidResponse);
        return adxBidResponse;
    }
}
