package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.response.Bid;
import lombok.Builder;
import lombok.Data;
import org.apache.commons.collections.MapUtils;

import java.io.Serializable;
import java.util.Map;

/**
 * @author fgf
 * @date 2023/1/9
 **/
@Data
@Builder
public class ResponseBuildAttribute implements Serializable {
    private static final long serialVersionUID = 1309553361486113841L;
    private BidRequest bidRequest;
    private Dispatcher dispatcher;
    private BidRequest adxRequest;
    private Buyer buyer;

    /**
     * 当前时段dsp出价具体配置
     */
    private Map<String,DispatcherPriceConfig> bidPriceConfigMap;

    public DispatcherPriceConfig getBidPriceConfig(Bid bid) {
        if (MapUtils.isEmpty(this.bidPriceConfigMap)) {
            return null;
        }
        return this.bidPriceConfigMap.get(buildKey(bid));
    }

    public DispatcherPriceConfig putBidPriceConfig(Bid bid, DispatcherPriceConfig config) {
        return this.bidPriceConfigMap.put(buildKey(bid), config);
    }

    private String buildKey(Bid bid) {
        return bid.getId() + "-" + bid.getAdid();
    }
}
