package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 计费类型过滤，cpc返回cpc，cpm返回cpm
 *
 * @author lijingyu
 * @since 2024-01-22
 */
@Slf4j
@Configuration
public class BidModelFilter implements Filter {

    @Override
    public void filter(List<Deal> deals, Set<Deal> trash) {
        Set<Deal> remove = deals.stream().filter(
                deal -> {
                    Integer bidModel = deal.getBidRequest().getBid_model();
                    BidResponse response = deal.getBidResponse();

                    List<SeatBid> seatBids = response.getSeat_bid();
                    seatBids.removeIf(seatBid -> {
                        List<Bid> bidList = seatBid.getBid();
                        // FIXME: 2024/1/26 bidmodel和chargetype不能直接拿来比较
                        bidList.removeIf(b -> !b.getCharge_type().equals(bidModel));

                        return CollectionUtils.isEmpty(bidList);
                    });
                    return CollectionUtils.isEmpty(seatBids);
                }
        ).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(remove)) {
            trash.addAll(remove);
        }
    }

    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE - 1;
    }
}
