package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

import javax.annotation.Resource;
import java.util.*;

/**
 * 多素材过滤
 *
 * @author lijingyu
 * @since 2024-01-22
 */
@Slf4j
@Configuration
@DealFilterCondition(chargeType = AdxConstants.BidModel.SUPPORT_CPC)
public class CpcPriceFilter implements Filter {

    @Resource
    private AdxProperties properties;

    @Override
    public void filter(List<Deal> deals, Set<Deal> trash) {
        deals.stream()
                .map(Deal::getBidResponse)
                .map(BidResponse::getSeat_bid)
                .flatMap(List::stream)
                .map(SeatBid::getBid)
                .forEach(bids -> {
                    bids.sort(Comparator.comparing(Bid::getBid).reversed());
                    if (properties.getMaxCreativesOfCpc() < bids.size()) {
                        bids.subList(properties.getMaxCreativesOfCpc(), bids.size()).clear();
                    }
                });
    }

    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }
}
