package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.openlog.event.internal.AdxDispatcherFilter;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import lombok.Data;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 流量分配过滤情况埋点
 *
 * @author fgf
 * @date 2023/11/13
 **/
@Slf4j
@Configuration
public class DotAdxDispatcherFilterEventListener implements EventListener<AdxDispatcherFilter> {
    private OpenLogClient openLogClient;
    private final AdxProperties properties;
    private final BuildAttributeStringMacrosHandler macrosHandler;

    public DotAdxDispatcherFilterEventListener(AdxProperties properties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.properties = properties;
        this.macrosHandler = macrosHandler;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdxDispatcherFilter event) {
        if (Math.abs(event.getSspRequest().getId().hashCode() % 100) >= properties.getDotSimplingPercent()) {
            return;
        }
        Map<Integer, Set<Dispatcher>> trash = event.getTrashMap();
        List<FilterEntity> filterEntities = getFilterEntity(trash);
        MultiValueMap<String, String> customizeParams = new LinkedMultiValueMap<>();
        String value = UrlHelper.urlEncode(JsonHelper.convert(filterEntities));
        customizeParams.add(OpenlogConstants.MacrosCustomizeParams.ADX_DISPATCHER_FILTER, value);
        String url = properties.getOpenLog().create(true, OpenlogConstants.Mt.ADX_DISPATCHER_FILTER, customizeParams, OpenlogConstants.WITHOUT_MACROS_INNER);
        BuildAttribute attribute = new BuildAttribute(OpenlogConstants.Mt.ADX_DISPATCHER_FILTER)
                .setSspRequest(event.getSspRequest());
        url = macrosHandler.replaceAll(url, attribute);
        if (log.isDebugEnabled()) {
            log.debug("url: {}", url);
        }
        openLogClient.asyncRequest(url);
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    public List<FilterEntity> getFilterEntity(Map<Integer, Set<Dispatcher>> trash) {
        List<FilterEntity> filterEntities = new ArrayList<>();
        for (Map.Entry<Integer, Set<Dispatcher>> entry : trash.entrySet()) {
            for (Dispatcher dispatcher : entry.getValue()) {
                filterEntities.add(
                        new FilterEntity()
                                .setType(entry.getKey())
                                .setDspid(dispatcher.getDspId())
                                .setDtagid(dispatcher.getDspPosid())
//                                .setDappid(dispatcher.getDspAppid())
                );
            }
        }
        return filterEntities;
    }

    @Data
    @Accessors(chain = true)
    static class FilterEntity {
        private int type;
        private Long dspid;
        private String dtagid;
//        private String dappid;
    }
}
